/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext;

import io.wcm.handler.richtext.RichTextRequest;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jdom2.Content;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class RichText {
    private static final Format JDOM_FORMAT = Format.getCompactFormat().setTextMode(Format.TextMode.PRESERVE);
    private final RichTextRequest richTextRequest;
    private final List<Content> content;

    public RichText(RichTextRequest richTextRequest, List<Content> content) {
        this.richTextRequest = richTextRequest;
        this.content = content;
    }

    public RichTextRequest getRichTextRequest() {
        return this.richTextRequest;
    }

    public boolean isValid() {
        return this.content != null && !this.content.isEmpty();
    }

    public Collection<Content> getContent() {
        return this.content;
    }

    public String getMarkup() {
        if (!this.isValid()) {
            return null;
        }
        return new XMLOutputter(JDOM_FORMAT).outputString(this.content);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)io.wcm.wcm.commons.util.ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
    }
}

