/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.richtext.RichText;
import io.wcm.handler.richtext.RichTextBuilder;
import io.wcm.handler.richtext.RichTextRequest;
import io.wcm.handler.richtext.TextMode;
import io.wcm.handler.richtext.impl.RichTextHandlerImpl;
import io.wcm.handler.url.UrlMode;
import java.util.Collection;
import org.apache.sling.api.resource.Resource;
import org.jdom2.Content;

final class RichTextBuilderImpl
implements RichTextBuilder {
    private final RichTextHandlerImpl richTextHandler;
    private final Resource resource;
    private final String text;
    private UrlMode urlMode;
    private TextMode textMode;
    private MediaArgs mediaArgs;

    public RichTextBuilderImpl(Resource resource, RichTextHandlerImpl richTextHandler) {
        this.resource = resource;
        this.text = null;
        this.richTextHandler = richTextHandler;
    }

    public RichTextBuilderImpl(String text, RichTextHandlerImpl richTextHandler) {
        this.resource = null;
        this.text = text;
        this.richTextHandler = richTextHandler;
    }

    @Override
    public RichTextBuilder urlMode(UrlMode value) {
        this.urlMode = value;
        return this;
    }

    @Override
    public RichTextBuilder textMode(TextMode value) {
        this.textMode = value;
        return this;
    }

    @Override
    public RichTextBuilder mediaArgs(MediaArgs value) {
        this.mediaArgs = value;
        return this;
    }

    @Override
    public RichText build() {
        RichTextRequest request = new RichTextRequest(this.resource, this.text, this.urlMode, this.textMode, this.mediaArgs);
        return this.richTextHandler.processRequest(request);
    }

    @Override
    public String buildMarkup() {
        return this.build().getMarkup();
    }

    @Override
    public Collection<Content> buildContent() {
        return this.build().getContent();
    }
}

