/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import io.wcm.handler.link.spi.LinkHandlerConfig;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.io.IOException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"cq:Page"}, selectors={"wcmio-handler-richtext-rte-plugins-links-config"}, extensions={"json"}, methods={"GET"})
public class RTELinkPluginConfig
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    static final String SELECTOR = "wcmio-handler-richtext-rte-plugins-links-config";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)request.getResourceResolver(), PageManager.class);
        Page page = pageManager.getContainingPage(resource);
        I18n i18n = new I18n((HttpServletRequest)request);
        LinkHandlerConfig linkHandlerConfig = (LinkHandlerConfig)AdaptTo.notNull((Adaptable)resource, LinkHandlerConfig.class);
        List linkTypes = linkHandlerConfig.getLinkTypes().stream().map(linkTypeClass -> (LinkType)AdaptTo.notNull((Adaptable)resource, (Class)linkTypeClass)).collect(Collectors.toList());
        try {
            JSONObject result = new JSONObject();
            JSONObject linkTypesConfigs = new JSONObject();
            for (LinkType linkType : linkTypes) {
                JSONObject linkTypeConfig = new JSONObject();
                linkTypeConfig.put("value", (Object)linkType.getId());
                linkTypeConfig.put("text", (Object)this.getI18nText("io.wcm.handler.link.components.granite.form.linkRefContainer." + linkType.getId() + ".type", i18n));
                linkTypesConfigs.put(linkType.getId(), (Object)linkTypeConfig);
            }
            result.put("linkTypes", (Object)linkTypesConfigs);
            JSONObject rootPaths = new JSONObject();
            for (LinkType linkType : linkTypes) {
                String rootPath = linkHandlerConfig.getLinkRootPath(page, linkType.getId());
                if (rootPath == null) continue;
                rootPaths.put(linkType.getId(), (Object)rootPath);
            }
            result.put("linkTypes", (Object)linkTypesConfigs);
            result.put("rootPaths", (Object)rootPaths);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(result.toString());
        }
        catch (JSONException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private String getI18nText(String key, I18n i18n) {
        try {
            return i18n.get(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }
}

