/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import java.util.regex.Pattern;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public final class DataPropertyUtil {
    private static final String HTML5_DATA_PREFIX = "data-";
    private static final Pattern HEADLESS_CAMEL_CASE_NAME_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    private static final Pattern HTML5_DATA_NAME_PATTERN = Pattern.compile("^data\\-[a-z][a-z0-9\\-]*$");

    private DataPropertyUtil() {
    }

    public static String toHtml5DataName(String headlessCamelCaseName) {
        if (StringUtils.isEmpty((CharSequence)headlessCamelCaseName)) {
            throw new IllegalArgumentException("Property name is empty.");
        }
        if (!DataPropertyUtil.isHeadlessCamelCaseName(headlessCamelCaseName)) {
            throw new IllegalArgumentException("This is not a valid headless camel case property name: " + headlessCamelCaseName);
        }
        StringBuilder html5DataName = new StringBuilder(HTML5_DATA_PREFIX);
        for (int i = 0; i < headlessCamelCaseName.length(); ++i) {
            char c = headlessCamelCaseName.charAt(i);
            if (CharUtils.isAsciiAlphaUpper((char)c)) {
                html5DataName.append('-');
            }
            html5DataName.append(Character.toLowerCase(c));
        }
        return html5DataName.toString();
    }

    public static String toHeadlessCamelCaseName(String html5DataName) {
        if (StringUtils.isEmpty((CharSequence)html5DataName)) {
            throw new IllegalArgumentException("Property name is empty.");
        }
        if (!DataPropertyUtil.isHtml5DataName(html5DataName)) {
            throw new IllegalArgumentException("This is not a valid HTML5 data property name: " + html5DataName);
        }
        String html5DataNameWithoutSuffix = StringUtils.substringAfter((String)html5DataName, (String)HTML5_DATA_PREFIX);
        StringBuilder headlessCamelCaseName = new StringBuilder();
        boolean upperCaseNext = false;
        for (int i = 0; i < html5DataNameWithoutSuffix.length(); ++i) {
            char c = html5DataNameWithoutSuffix.charAt(i);
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                headlessCamelCaseName.append(Character.toUpperCase(c));
                upperCaseNext = false;
                continue;
            }
            headlessCamelCaseName.append(c);
        }
        return headlessCamelCaseName.toString();
    }

    public static boolean isHeadlessCamelCaseName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return HEADLESS_CAMEL_CASE_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isHtml5DataName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return HTML5_DATA_NAME_PATTERN.matcher(name).matches();
    }
}

