/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.richtext.TextMode;
import io.wcm.handler.url.UrlMode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class RichTextRequest {
    private final Resource resource;
    private final String text;
    private final UrlMode urlMode;
    private final TextMode textMode;
    private final MediaArgs mediaArgs;
    private ValueMap resourceProperties;

    public RichTextRequest(@Nullable Resource resource, @Nullable String text, @Nullable UrlMode urlMode, @Nullable TextMode textMode, @Nullable MediaArgs mediaArgs) {
        this.resource = resource;
        this.text = text;
        this.urlMode = urlMode;
        this.textMode = textMode;
        this.mediaArgs = mediaArgs;
        if (this.resource != null && this.text != null) {
            throw new IllegalArgumentException("Set resource or text, not both.");
        }
    }

    @Nullable
    public Resource getResource() {
        return this.resource;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nullable
    public UrlMode getUrlMode() {
        return this.urlMode;
    }

    @Nullable
    public TextMode getTextMode() {
        return this.textMode;
    }

    @Nullable
    public MediaArgs getMediaArgs() {
        return this.mediaArgs;
    }

    @NotNull
    public ValueMap getResourceProperties() {
        if (this.resourceProperties == null) {
            this.resourceProperties = new ValueMapDecorator(new HashMap());
            if (this.resource != null) {
                this.resourceProperties.putAll((Map)this.resource.getValueMap());
            }
        }
        return this.resourceProperties;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)io.wcm.wcm.commons.util.ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
    }
}

