/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.util;

import io.wcm.handler.richtext.util.RewriteContentHandler;
import io.wcm.handler.richtext.util.XHtmlEntityResolver;
import io.wcm.handler.richtext.util.XHtmlResource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.xml.sax.EntityResolver;

@ProviderType
public final class RichTextUtil {
    private static final int EMPTYTEXT_DEFAULT_TRESHOLD = 20;
    private static final String XHTML_ENTITY_DEF = "<!ENTITY % HTMLlat1 PUBLIC \"" + XHtmlResource.ENTITIES_LAT1.getPublicId() + "\" \"" + XHtmlResource.ENTITIES_LAT1.getSystemId() + "\">%HTMLlat1;<!ENTITY % HTMLsymbol PUBLIC \"" + XHtmlResource.ENTITIES_SYMBOL.getPublicId() + "\" \"" + XHtmlResource.ENTITIES_SYMBOL.getSystemId() + "\">%HTMLsymbol;<!ENTITY % HTMLspecial PUBLIC \"" + XHtmlResource.ENTITIES_SPECIAL.getPublicId() + "\" \"" + XHtmlResource.ENTITIES_SPECIAL.getSystemId() + "\">%HTMLspecial;";
    private static final Pattern CONTROL_CHARS_NOT_ALLOWED_IN_XML10 = Pattern.compile("[^\t\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]");

    private RichTextUtil() {
    }

    public static boolean isEmpty(@Nullable String text) {
        return RichTextUtil.isEmpty(text, 20);
    }

    public static boolean isEmpty(@Nullable String text, int treshold) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return true;
        }
        if (text.length() > treshold) {
            return false;
        }
        String cleanedText = StringUtils.replace((String)text, (String)" ", (String)"");
        cleanedText = StringUtils.replace((String)cleanedText, (String)"&#160;", (String)"");
        cleanedText = StringUtils.replace((String)cleanedText, (String)"&nbsp;", (String)"");
        cleanedText = StringUtils.replace((String)cleanedText, (String)"\n", (String)"");
        return StringUtils.isEmpty((CharSequence)(cleanedText = StringUtils.replace((String)cleanedText, (String)"\r", (String)""))) || "<p></p>".equals(cleanedText);
    }

    public static void addParsedText(@NotNull Element parent, @NotNull String text) throws JDOMException {
        RichTextUtil.addParsedText(parent, text, false);
    }

    public static void addParsedText(@NotNull Element parent, @NotNull String text, boolean xhtmlEntities) throws JDOMException {
        Element root = RichTextUtil.parseText(text, xhtmlEntities);
        parent.addContent((Collection)root.cloneContent());
    }

    public static Element parseText(@NotNull String text) throws JDOMException {
        return RichTextUtil.parseText(text, false);
    }

    @NotNull
    public static Element parseText(@NotNull String text, boolean xhtmlEntities) throws JDOMException {
        String xhtmlString = (String)(xhtmlEntities ? "<!DOCTYPE root [" + XHTML_ENTITY_DEF + "]>" : "") + "<root>" + RichTextUtil.removeCharsNotAllowedInXML10(text) + "</root>";
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            if (xhtmlEntities) {
                saxBuilder.setEntityResolver((EntityResolver)XHtmlEntityResolver.getInstance());
            }
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxBuilder.setExpandEntities(false);
            if (!xhtmlEntities) {
                saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            Document doc = saxBuilder.build((Reader)new StringReader(xhtmlString));
            return doc.getRootElement();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing XHTML fragment.", ex);
        }
    }

    private static String removeCharsNotAllowedInXML10(String value) {
        return CONTROL_CHARS_NOT_ALLOWED_IN_XML10.matcher(value).replaceAll("");
    }

    public static void rewriteContent(@NotNull Element parent, @NotNull RewriteContentHandler rewriteContentHandler) {
        List originalContent = parent.getContent();
        ArrayList<Object> newContent = new ArrayList<Object>();
        for (Content contentElement : originalContent) {
            List<Content> rewriteContent;
            if (contentElement instanceof Element) {
                Element element = (Element)contentElement;
                rewriteContent = rewriteContentHandler.rewriteElement(element);
                if (rewriteContent != null) {
                    if (rewriteContent.isEmpty()) continue;
                    if (rewriteContent.size() == 1 && rewriteContent.get(0) == element) {
                        RichTextUtil.rewriteContent(element, rewriteContentHandler);
                        newContent.add(element);
                        continue;
                    }
                    for (Content newContentItem : rewriteContent) {
                        if (newContentItem instanceof Element) {
                            Element newElement = (Element)newContentItem;
                            RichTextUtil.rewriteContent(newElement, rewriteContentHandler);
                        }
                        newContent.add(newContentItem.clone());
                    }
                    continue;
                }
                RichTextUtil.rewriteContent(element, rewriteContentHandler);
                newContent.add(element);
                continue;
            }
            if (contentElement instanceof Text) {
                Text text = (Text)contentElement;
                rewriteContent = rewriteContentHandler.rewriteText(text);
                if (rewriteContent != null) {
                    if (rewriteContent.isEmpty()) continue;
                    if (rewriteContent.size() == 1 && rewriteContent.get(0) == text) {
                        newContent.add(text);
                        continue;
                    }
                    for (Content newContentItem : rewriteContent) {
                        newContent.add(newContentItem.clone());
                    }
                    continue;
                }
                newContent.add(text);
                continue;
            }
            newContent.add(contentElement);
        }
        parent.removeContent();
        parent.addContent(newContent);
    }
}

