/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.handler.link.spi.LinkHandlerConfig;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.link.type.InternalLinkType;
import io.wcm.handler.link.type.MediaLinkType;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.richtext.impl.DataPropertyUtil;
import io.wcm.handler.richtext.util.RewriteContentHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
public final class DefaultRewriteContentHandler
implements RewriteContentHandler {
    @Self
    private Adaptable adaptable;
    @SlingObject
    private ResourceResolver resourceResolver;
    @Self
    private LinkHandler linkHandler;
    @Self
    private LinkHandlerConfig linkHandlerConfig;
    @Self
    private MediaHandler mediaHandler;
    private static final Logger log = LoggerFactory.getLogger(DefaultRewriteContentHandler.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};
    private static final Set<String> NONSELFCLOSING_TAGS = Set.of("div", "span", "strong", "em", "b", "i", "ul", "ol", "li");

    @Override
    @Nullable
    public List<Content> rewriteElement(@NotNull Element element) {
        if (StringUtils.equalsIgnoreCase((CharSequence)element.getName(), (CharSequence)"a")) {
            return this.rewriteAnchor(element);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)element.getName(), (CharSequence)"img")) {
            return this.rewriteImage(element);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)element.getName(), (CharSequence)"br")) {
            if (!element.getContent().isEmpty()) {
                element.removeContent();
            }
            return null;
        }
        if (NONSELFCLOSING_TAGS.contains(StringUtils.lowerCase((String)element.getName()))) {
            if (element.getContent().isEmpty()) {
                element.setText("");
            }
            return null;
        }
        return null;
    }

    private List<Content> rewriteAnchor(@NotNull Element element) {
        if (element.getContent().isEmpty()) {
            element.setText("");
        }
        Link link = this.getAnchorLink(element);
        Element anchorElement = this.buildAnchorElement(link, element);
        ArrayList<Content> content = new ArrayList<Content>();
        if (anchorElement != null) {
            anchorElement.addContent((Collection)element.cloneContent());
            content.add((Content)anchorElement);
        } else {
            content.addAll(element.getContent());
        }
        return content;
    }

    private Link getAnchorLink(Element element) {
        Resource currentResource = this.getCurrentResource();
        if (currentResource == null) {
            return this.linkHandler.invalid();
        }
        SyntheticLinkResource resource = new SyntheticLinkResource(this.resourceResolver, currentResource.getPath() + "/$link$");
        ValueMap resourceProps = resource.getValueMap();
        boolean foundMetadata = this.getAnchorMetadataFromData(resourceProps, element);
        if (!foundMetadata && !(foundMetadata = this.getAnchorLegacyMetadataFromSingleData(resourceProps, element))) {
            this.getAnchorLegacyMetadataFromRel(resourceProps, element);
        }
        return this.linkHandler.get((Resource)resource).build();
    }

    private Element buildAnchorElement(Link link, Element element) {
        if (link.isValid()) {
            return link.getAnchor();
        }
        if ((element.getAttributeValue("id") != null || element.getAttributeValue("name") != null) && element.getAttributeValue("src") == null) {
            return element;
        }
        return null;
    }

    private boolean getAnchorMetadataFromData(ValueMap resourceProps, Element element) {
        boolean foundAny = false;
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String value;
            if (!DataPropertyUtil.isHtml5DataName(attribute.getName()) || !StringUtils.isNotEmpty((CharSequence)(value = attribute.getValue()))) continue;
            String property = DataPropertyUtil.toHeadlessCamelCaseName(attribute.getName());
            if (StringUtils.startsWith((CharSequence)value, (CharSequence)"[") && StringUtils.endsWith((CharSequence)value, (CharSequence)"]")) {
                try {
                    String[] values = (String[])OBJECT_MAPPER.readValue(value, String[].class);
                    resourceProps.put((Object)property, (Object)values);
                }
                catch (JsonProcessingException ex) {
                    log.debug("Unable to parse JSON array: {}", (Object)value, (Object)ex);
                }
            } else {
                resourceProps.put((Object)property, (Object)value);
            }
            foundAny = true;
        }
        return foundAny;
    }

    private boolean getAnchorLegacyMetadataFromSingleData(ValueMap resourceProps, Element element) {
        String metadataString;
        boolean foundAny = false;
        Map metadata = null;
        Attribute dataAttribute = element.getAttribute("data");
        if (dataAttribute != null && StringUtils.isNotEmpty((CharSequence)(metadataString = dataAttribute.getValue()))) {
            try {
                metadata = (Map)OBJECT_MAPPER.readValue(metadataString, MAP_TYPE_REFERENCE);
            }
            catch (JsonProcessingException ex) {
                log.debug("Invalid link metadata: {}", (Object)metadataString, (Object)ex);
            }
        }
        if (metadata != null) {
            for (Map.Entry entry : metadata.entrySet()) {
                resourceProps.put((Object)((String)entry.getKey()), entry.getValue());
                foundAny = true;
            }
        }
        return foundAny;
    }

    private void getAnchorLegacyMetadataFromRel(ValueMap resourceProps, Element element) {
        String htmlSuffix;
        String href = element.getAttributeValue("href");
        String linkWindowTarget = element.getAttributeValue("target");
        if (href == null || href.startsWith("#")) {
            return;
        }
        Map metadata = null;
        String metadataString = element.getAttributeValue("rel");
        if (StringUtils.isNotEmpty((CharSequence)metadataString)) {
            try {
                metadata = (Map)OBJECT_MAPPER.readValue(metadataString, MAP_TYPE_REFERENCE);
            }
            catch (JsonProcessingException ex) {
                log.debug("Invalid link metadata: {}", (Object)metadataString, (Object)ex);
            }
        }
        if (metadata == null) {
            metadata = new HashMap();
        }
        for (Map.Entry entry : metadata.entrySet()) {
            String metadataPropertyName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                resourceProps.put((Object)metadataPropertyName, (Object)((Collection)value).toArray());
                continue;
            }
            if (value.getClass().isArray()) {
                ArrayList<String> values = new ArrayList<String>();
                int arrayLength = Array.getLength(value);
                for (int j = 0; j < arrayLength; ++j) {
                    Object arrayItem = Array.get(value, j);
                    if (arrayItem == null) continue;
                    values.add(arrayItem.toString());
                }
                resourceProps.put((Object)metadataPropertyName, (Object)values.toArray());
                continue;
            }
            resourceProps.put((Object)metadataPropertyName, value);
        }
        LinkType linkType = null;
        String linkTypeString = (String)resourceProps.get("linkType", String.class);
        for (Class candidateClass : this.linkHandlerConfig.getLinkTypes()) {
            LinkType candidate = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, (Class)candidateClass);
            if (StringUtils.isNotEmpty((CharSequence)linkTypeString)) {
                if (!StringUtils.equals((CharSequence)linkTypeString, (CharSequence)candidate.getId())) continue;
                linkType = candidate;
                break;
            }
            if (!candidate.accepts(href)) continue;
            linkType = candidate;
            break;
        }
        if (linkType == null) {
            return;
        }
        if ((linkType instanceof InternalLinkType || linkType instanceof MediaLinkType) && StringUtils.endsWith((CharSequence)href, (CharSequence)(htmlSuffix = ".html"))) {
            href = StringUtils.substringBeforeLast((String)href, (String)htmlSuffix);
        }
        resourceProps.put((Object)linkType.getPrimaryLinkRefProperty(), (Object)href);
        resourceProps.put((Object)"linkWindowTarget", (Object)linkWindowTarget);
    }

    private List<Content> rewriteImage(@NotNull Element element) {
        Media media = this.getImageMedia(element);
        Element imageElement = this.buildImageElement(media, element);
        ArrayList<Content> content = new ArrayList<Content>();
        content.add((Content)imageElement);
        return content;
    }

    private Media getImageMedia(@NotNull Element element) {
        String ref = element.getAttributeValue("src");
        if (StringUtils.isNotEmpty((CharSequence)ref)) {
            ref = this.unexternalizeImageRef(ref);
        }
        return this.mediaHandler.get(ref).build();
    }

    private Element buildImageElement(@NotNull Media media, @NotNull Element element) {
        if (media.isValid()) {
            element.setAttribute("src", media.getUrl());
        }
        return element;
    }

    private String unexternalizeImageRef(String ref) {
        String unexternalizedRef = ref;
        if (StringUtils.isNotEmpty((CharSequence)unexternalizedRef)) {
            unexternalizedRef = this.decodeIfEncoded(unexternalizedRef);
            unexternalizedRef = StringUtils.removeEnd((String)unexternalizedRef, (String)"/jcr:content.default");
            unexternalizedRef = StringUtils.removeEnd((String)unexternalizedRef, (String)"/_jcr_content.default");
        }
        return unexternalizedRef;
    }

    private String decodeIfEncoded(String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)"%")) {
            return URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
        return value;
    }

    @Override
    @Nullable
    public List<Content> rewriteText(@NotNull Text text) {
        return null;
    }

    @Nullable
    private Resource getCurrentResource() {
        if (this.adaptable instanceof Resource) {
            return (Resource)this.adaptable;
        }
        if (this.adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)this.adaptable).getResource();
        }
        return null;
    }
}

