/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wcm.handler.link.spi.LinkHandlerConfig;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.contenttype.ContentType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"cq:Page"}, selectors={"wcmio-handler-richtext-rte-plugins-links-config"}, extensions={"json"}, methods={"GET"})
public class RTELinkPluginConfig
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    static final String SELECTOR = "wcmio-handler-richtext-rte-plugins-links-config";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)request.getResourceResolver(), PageManager.class);
        Page page = pageManager.getContainingPage(resource);
        I18n i18n = new I18n((HttpServletRequest)request);
        LinkHandlerConfig linkHandlerConfig = (LinkHandlerConfig)AdaptTo.notNull((Adaptable)resource, LinkHandlerConfig.class);
        List linkTypes = linkHandlerConfig.getLinkTypes().stream().map(linkTypeClass -> (LinkType)AdaptTo.notNull((Adaptable)resource, (Class)linkTypeClass)).filter(LinkType::hasRichTextPlugin).collect(Collectors.toList());
        Result result = new Result();
        LinkedHashMap<String, LinkTypeConfig> linkTypesConfigs = new LinkedHashMap<String, LinkTypeConfig>();
        for (LinkType linkType : linkTypes) {
            LinkTypeConfig linkTypeConfig = new LinkTypeConfig();
            linkTypeConfig.value = linkType.getId();
            linkTypeConfig.text = this.getI18nText("io.wcm.handler.link.components.granite.form.linkRefContainer." + linkType.getId() + ".type", i18n);
            linkTypesConfigs.put(linkType.getId(), linkTypeConfig);
        }
        result.linkTypes = linkTypesConfigs;
        LinkedHashMap<String, String> rootPaths = new LinkedHashMap<String, String>();
        for (LinkType linkType : linkTypes) {
            String rootPath = linkHandlerConfig.getLinkRootPath(page, linkType.getId());
            if (rootPath == null) continue;
            rootPaths.put(linkType.getId(), rootPath);
        }
        result.linkTypes = linkTypesConfigs;
        result.rootPaths = rootPaths;
        response.setContentType(ContentType.JSON);
        response.getWriter().write(OBJECT_MAPPER.writeValueAsString((Object)result));
    }

    private String getI18nText(String key, I18n i18n) {
        try {
            return i18n.get(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class LinkTypeConfig {
        private String value;
        private String text;

        LinkTypeConfig() {
        }

        public String getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class Result {
        private Map<String, LinkTypeConfig> linkTypes;
        private Map<String, String> rootPaths;

        Result() {
        }

        public Map<String, LinkTypeConfig> getLinkTypes() {
            return this.linkTypes;
        }

        public Map<String, String> getRootPaths() {
            return this.rootPaths;
        }
    }
}

