/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.richtext.RichText;
import io.wcm.handler.richtext.RichTextBuilder;
import io.wcm.handler.richtext.RichTextHandler;
import io.wcm.handler.richtext.RichTextRequest;
import io.wcm.handler.richtext.TextMode;
import io.wcm.handler.richtext.impl.RichTextBuilderImpl;
import io.wcm.handler.richtext.spi.RichTextHandlerConfig;
import io.wcm.handler.richtext.util.RewriteContentHandler;
import io.wcm.handler.richtext.util.RichTextUtil;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import io.wcm.sling.models.annotations.AemObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={RichTextHandler.class})
public final class RichTextHandlerImpl
implements RichTextHandler {
    static final Logger log = LoggerFactory.getLogger(RichTextHandlerImpl.class);
    @Self
    private Adaptable adaptable;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;
    @OSGiService
    private ContextAwareServiceResolver serviceResolver;
    private List<RewriteContentHandler> rewriteContentHandlers;

    @Override
    @NotNull
    public RichTextBuilder get(@Nullable Resource resource) {
        return new RichTextBuilderImpl(resource, this);
    }

    @Override
    @NotNull
    public RichTextBuilder get(@Nullable String text) {
        return new RichTextBuilderImpl(text, this);
    }

    @NotNull
    RichText processRequest(@NotNull RichTextRequest richTextRequest) {
        String text = this.getRawText(richTextRequest);
        TextMode textMode = this.getTextMode(richTextRequest);
        List<Content> content = textMode == TextMode.XHTML ? this.processRichText(text) : this.processPlainText(text);
        return new RichText(richTextRequest, content);
    }

    private String getRawText(RichTextRequest richTextRequest) {
        if (richTextRequest.getResource() != null) {
            return (String)richTextRequest.getResourceProperties().get("text", String.class);
        }
        return richTextRequest.getText();
    }

    private TextMode getTextMode(RichTextRequest richTextRequest) {
        if (richTextRequest.getTextMode() != null) {
            return richTextRequest.getTextMode();
        }
        if (richTextRequest.getResource() != null) {
            boolean textIsRich = (Boolean)richTextRequest.getResourceProperties().get("textIsRich", (Object)true);
            return textIsRich ? TextMode.XHTML : TextMode.PLAIN;
        }
        return TextMode.XHTML;
    }

    private List<Content> processRichText(String text) {
        if (this.isEmpty(text)) {
            return Collections.emptyList();
        }
        try {
            Element contentParent = RichTextUtil.parseText(text, true);
            List<RewriteContentHandler> rewriters = this.getRewriterContentHandlers();
            for (RewriteContentHandler rewriter : rewriters) {
                RichTextUtil.rewriteContent(contentParent, rewriter);
            }
            return List.copyOf(contentParent.cloneContent());
        }
        catch (JDOMException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to parse XHTML text." + (String)(this.currentPage != null ? " Current page is " + this.currentPage.getPath() + "." : ""), (Throwable)ex);
            }
            return Collections.emptyList();
        }
    }

    private List<Content> processPlainText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return Collections.emptyList();
        }
        ArrayList<Object> content = new ArrayList<Object>();
        String[] lines = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)"\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                content.add(new Element("br"));
            }
            content.add(new Text(lines[i]));
        }
        return List.copyOf(content);
    }

    @Override
    public boolean isEmpty(@Nullable String text) {
        return RichTextUtil.isEmpty(text);
    }

    private List<RewriteContentHandler> getRewriterContentHandlers() {
        RichTextHandlerConfig config;
        if (this.rewriteContentHandlers == null && (config = (RichTextHandlerConfig)this.serviceResolver.resolve(RichTextHandlerConfig.class, this.adaptable)) != null) {
            this.rewriteContentHandlers = new ArrayList<RewriteContentHandler>();
            for (Class<? extends RewriteContentHandler> clazz : config.getRewriteContentHandlers()) {
                RewriteContentHandler rewriter = (RewriteContentHandler)this.adaptable.adaptTo(clazz);
                if (rewriter == null) {
                    throw new IllegalStateException("Unable to adapt " + this.adaptable.getClass() + " to " + clazz.getName() + ". Make sure the class is a Sling Model and adaptable from Resource and SlingHttpServletRequest.");
                }
                this.rewriteContentHandlers.add(rewriter);
            }
        }
        return this.rewriteContentHandlers;
    }
}

