/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.ui;

import io.wcm.handler.richtext.RichTextBuilder;
import io.wcm.handler.richtext.RichTextHandler;
import io.wcm.handler.richtext.TextMode;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class})
public class ResourceRichText {
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={"text"})
    private String propertyName;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(booleanValues={true})
    private boolean isRichText;
    @Self
    private RichTextHandler richTextHandler;
    @SlingObject
    private Resource resource;
    private String markup;

    @PostConstruct
    private void activate() {
        String text = (String)this.resource.getValueMap().get(this.propertyName, String.class);
        RichTextBuilder builder = this.richTextHandler.get(text);
        if (!this.isRichText) {
            builder.textMode(TextMode.PLAIN);
        }
        this.markup = builder.buildMarkup();
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.getMarkup());
    }

    @Nullable
    public String getMarkup() {
        return this.markup;
    }
}

