/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.util;

import io.wcm.handler.richtext.util.XHtmlResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XHtmlEntityResolver
implements EntityResolver {
    private static final XHtmlEntityResolver INSTANCE = new XHtmlEntityResolver();
    private final Map<String, String> xhtmlResourceMap = new HashMap<String, String>();
    private final String resourceFolder = "/" + this.getClass().getPackage().getName().replace('.', '/') + "/xhtml";

    private XHtmlEntityResolver() {
        for (XHtmlResource resource : EnumSet.allOf(XHtmlResource.class)) {
            this.xhtmlResourceMap.put(resource.getPublicId(), resource.getFilename());
        }
    }

    @NotNull
    public static XHtmlEntityResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String filename = this.xhtmlResourceMap.get(publicId);
        if (filename != null) {
            String resourceName = this.resourceFolder + "/" + filename;
            InputStream is = XHtmlEntityResolver.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new IOException("Resource '" + resourceName + "' not found in class path.");
            }
            return new InputSource(is);
        }
        return null;
    }
}

