/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.wcm.handler.url.SiteConfig;
import io.wcm.handler.url.spi.UrlHandlerConfig;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AdapterFactory.class}, property={"adaptables=org.apache.sling.api.resource.Resource", "adaptables=org.apache.sling.api.SlingHttpServletRequest", "adapters=io.wcm.handler.url.spi.UrlHandlerConfig", "adapters=io.wcm.handler.url.SiteConfig"})
public class UrlHandlerAdapterFactory
implements AdapterFactory {
    @Reference
    private ContextAwareServiceResolver serviceResolver;
    @Reference
    private ConfigurationResourceResolver configurationResourceResolver;
    private static final Logger log = LoggerFactory.getLogger(UrlHandlerAdapterFactory.class);
    private final Cache<String, SiteConfig> siteConfigCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).maximumSize(10000L).build();

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (type == UrlHandlerConfig.class) {
            return (AdapterType)this.serviceResolver.resolve(UrlHandlerConfig.class, (Adaptable)adaptable);
        }
        if (type == SiteConfig.class) {
            return (AdapterType)this.getSiteConfigForSiteRoot(this.getContextResource(adaptable));
        }
        return null;
    }

    private Resource getContextResource(Object adaptable) {
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)adaptable).getResource();
        }
        return null;
    }

    private SiteConfig getSiteConfigForSiteRoot(Resource contextResource) {
        if (contextResource == null) {
            return null;
        }
        String contextRootPath = this.configurationResourceResolver.getContextPath(contextResource);
        if (StringUtils.isBlank((CharSequence)contextRootPath)) {
            return this.getSiteConfigForResource(contextResource);
        }
        try {
            return (SiteConfig)this.siteConfigCache.get((Object)contextRootPath, () -> {
                Resource siteRootResource = contextResource.getResourceResolver().getResource(contextRootPath);
                return this.getSiteConfigForResourceCacheable(siteRootResource);
            });
        }
        catch (ExecutionException ex) {
            log.warn("Unexpected exception.", (Throwable)ex);
            return null;
        }
    }

    private SiteConfig getSiteConfigForResourceCacheable(Resource contextResource) {
        final SiteConfig siteConfig = this.getSiteConfigForResource(contextResource);
        return new SiteConfig(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return SiteConfig.class;
            }

            @Override
            public String siteUrl() {
                return siteConfig.siteUrl();
            }

            @Override
            public String siteUrlSecure() {
                return siteConfig.siteUrlSecure();
            }

            @Override
            public String siteUrlAuthor() {
                return siteConfig.siteUrlAuthor();
            }
        };
    }

    private SiteConfig getSiteConfigForResource(Resource contextResource) {
        ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)contextResource.adaptTo(ConfigurationBuilder.class);
        if (configurationBuilder == null) {
            throw new RuntimeException("No configuration builder.");
        }
        return (SiteConfig)configurationBuilder.as(SiteConfig.class);
    }
}

