/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl.clientlib;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wcm.handler.url.impl.clientlib.ClientlibPathCacheEntry;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.api.observation.JackrabbitObservationManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientlibPathCache
implements EventListener,
AutoCloseable {
    private final ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver listenerServiceResourceResolver;
    private static final String NT_CLIENTLIBRARY = "cq:ClientLibraryFolder";
    private static final String PN_ALLOWPROXY = "allowProxy";
    private static final String CLIENTLIBS_SERVICE = "clientlibs-service";
    private static final String SERVICE_USER_MAPPING_WARNING = "Missing service user mapping for 'io.wcm.handler.url:clientlibs-service' - see https://wcm.io/handler/url/configuration.html";
    private final LoadingCache<String, ClientlibPathCacheEntry> cache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, ClientlibPathCacheEntry>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ClientlibPathCacheEntry load(String path) throws Exception {
            try (ResourceResolver resourceResolver = ClientlibPathCache.this.getServiceResourceResolver();){
                Resource resource = resourceResolver.getResource(path);
                if (resource == null) return new ClientlibPathCacheEntry(path, false, false);
                Node node = (Node)resource.adaptTo(Node.class);
                if (node == null) return new ClientlibPathCacheEntry(path, false, false);
                if (!node.isNodeType(ClientlibPathCache.NT_CLIENTLIBRARY)) return new ClientlibPathCacheEntry(path, false, false);
                boolean isAllowProxy = (Boolean)resource.getValueMap().get(ClientlibPathCache.PN_ALLOWPROXY, (Object)false);
                ClientlibPathCacheEntry entry = new ClientlibPathCacheEntry(path, true, isAllowProxy);
                log.debug("Detected client library: {}", (Object)entry);
                ClientlibPathCacheEntry clientlibPathCacheEntry = entry;
                return clientlibPathCacheEntry;
            }
            catch (LoginException ex) {
                log.warn(ClientlibPathCache.SERVICE_USER_MAPPING_WARNING);
            }
            return new ClientlibPathCacheEntry(path, false, false);
        }
    });
    private static final Logger log = LoggerFactory.getLogger(ClientlibPathCache.class);

    ClientlibPathCache(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
        try {
            this.listenerServiceResourceResolver = this.getServiceResourceResolver();
            this.enableObservationForClientLibraries();
        }
        catch (LoginException ex) {
            log.warn(SERVICE_USER_MAPPING_WARNING);
        }
    }

    private ResourceResolver getServiceResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", CLIENTLIBS_SERVICE));
    }

    private void enableObservationForClientLibraries() {
        Session session = (Session)this.listenerServiceResourceResolver.adaptTo(Session.class);
        if (session != null) {
            try {
                log.debug("Enable observation for client libraries.");
                JackrabbitObservationManager observationManager = (JackrabbitObservationManager)session.getWorkspace().getObservationManager();
                JackrabbitEventFilter eventFilter = new JackrabbitEventFilter().setEventTypes(63).setAbsPath("/apps").setAdditionalPaths(new String[]{"/apps", "/libs"}).setIsDeep(true).setNodeTypes(new String[]{NT_CLIENTLIBRARY});
                observationManager.addEventListener((EventListener)this, eventFilter);
            }
            catch (RepositoryException ex) {
                log.warn("Unable to register obervation for client libraries.");
            }
        }
    }

    public void onEvent(EventIterator events) {
        log.debug("Clear client library path cache.");
        this.cache.invalidateAll();
    }

    public boolean isClientlibWithAllowProxy(String path) {
        try {
            ClientlibPathCacheEntry entry = (ClientlibPathCacheEntry)this.cache.get((Object)path);
            return entry.isClientLibrary() && entry.isAllowProxy();
        }
        catch (ExecutionException ex) {
            log.warn("Error accessing cache.", (Throwable)ex);
            return false;
        }
    }

    @Override
    public void close() {
        if (this.listenerServiceResourceResolver != null) {
            log.debug("End observation for client libraries.");
            this.listenerServiceResourceResolver.close();
        }
    }
}

