/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.suffix;

import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.wcm.handler.url.suffix.FilteringSuffixStateStrategy;
import io.wcm.handler.url.suffix.SuffixStateKeepingStrategy;
import io.wcm.handler.url.suffix.impl.ExcludeNamedPartsFilter;
import io.wcm.handler.url.suffix.impl.ExcludeResourcePartsFilter;
import io.wcm.handler.url.suffix.impl.ExcludeSpecificResourceFilter;
import io.wcm.handler.url.suffix.impl.FilterOperators;
import io.wcm.handler.url.suffix.impl.IncludeAllPartsFilter;
import io.wcm.handler.url.suffix.impl.IncludeNamedPartsFilter;
import io.wcm.handler.url.suffix.impl.IncludeResourcePartsFilter;
import io.wcm.handler.url.suffix.impl.UrlSuffixUtil;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class SuffixBuilder {
    private final List<String> initialSuffixParts;
    private final Map<String, Object> parameterMap = new HashMap<String, Object>();
    private final List<String> resourcePaths = new ArrayList<String>();

    public SuffixBuilder() {
        this.initialSuffixParts = new ArrayList<String>();
    }

    public SuffixBuilder(@NotNull SlingHttpServletRequest request, @NotNull SuffixStateKeepingStrategy stateStrategy) {
        this.initialSuffixParts = stateStrategy.getSuffixPartsToKeep(request);
    }

    public SuffixBuilder(@NotNull SlingHttpServletRequest request, @NotNull Predicate<String> suffixPartFilter) {
        this(request, new FilteringSuffixStateStrategy(suffixPartFilter));
    }

    @NotNull
    public static SuffixBuilder thatDiscardsAllSuffixState() {
        return new SuffixBuilder();
    }

    @NotNull
    public static SuffixBuilder thatKeepsResourceParts(@NotNull SlingHttpServletRequest request) {
        IncludeResourcePartsFilter filter = new IncludeResourcePartsFilter();
        return new SuffixBuilder(request, filter);
    }

    @NotNull
    public static SuffixBuilder thatKeepsNamedParts(@NotNull SlingHttpServletRequest request, String ... keysToKeep) {
        IncludeNamedPartsFilter filter = new IncludeNamedPartsFilter(keysToKeep);
        return new SuffixBuilder(request, filter);
    }

    @NotNull
    public static SuffixBuilder thatKeepsNamedPartsAndResources(@NotNull SlingHttpServletRequest request, String ... keysToKeep) {
        Predicate<String> filter = FilterOperators.or(new IncludeResourcePartsFilter(), new IncludeNamedPartsFilter(keysToKeep));
        return new SuffixBuilder(request, filter);
    }

    @NotNull
    public static SuffixBuilder thatKeepsAllParts(@NotNull SlingHttpServletRequest request) {
        return new SuffixBuilder(request, new IncludeAllPartsFilter());
    }

    @NotNull
    public static SuffixBuilder thatDiscardsResourceParts(@NotNull SlingHttpServletRequest request) {
        ExcludeResourcePartsFilter filter = new ExcludeResourcePartsFilter();
        return new SuffixBuilder(request, filter);
    }

    @NotNull
    public static SuffixBuilder thatDiscardsNamedParts(@NotNull SlingHttpServletRequest request, String ... keysToDiscard) {
        return new SuffixBuilder(request, new ExcludeNamedPartsFilter(keysToDiscard));
    }

    @NotNull
    public static SuffixBuilder thatDiscardsResourceAndNamedParts(@NotNull SlingHttpServletRequest request, String ... keysToDiscard) {
        Predicate<String> filter = FilterOperators.and(new ExcludeResourcePartsFilter(), new ExcludeNamedPartsFilter(keysToDiscard));
        return new SuffixBuilder(request, filter);
    }

    @NotNull
    public static SuffixBuilder thatDiscardsSpecificResourceAndNamedParts(@NotNull SlingHttpServletRequest request, @NotNull String resourcePathToDiscard, String ... keysToDiscard) {
        Predicate<String> filter = FilterOperators.and(new ExcludeSpecificResourceFilter(resourcePathToDiscard), new ExcludeNamedPartsFilter(keysToDiscard));
        return new SuffixBuilder(request, filter);
    }

    @NotNull
    public SuffixBuilder put(@NotNull String key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (value != null) {
            this.validateValueType(value);
            this.parameterMap.put(key, value);
        }
        return this;
    }

    @NotNull
    public SuffixBuilder putAll(@NotNull Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private void validateValueType(Object value) {
        boolean isValid;
        Class<?> clazz = value.getClass();
        boolean bl = isValid = clazz == String.class || clazz == Boolean.class || clazz == Integer.class || clazz == Long.class;
        if (!isValid) {
            throw new IllegalArgumentException("Unsupported value type: " + clazz.getName());
        }
    }

    @NotNull
    public SuffixBuilder resource(@NotNull Resource resource, @NotNull Resource suffixBaseResource) {
        String relativePath = UrlSuffixUtil.getRelativePath(resource, suffixBaseResource);
        this.resourcePaths.add(relativePath);
        return this;
    }

    @NotNull
    public SuffixBuilder resources(@NotNull List<Resource> resources, @NotNull Resource baseResource) {
        for (Resource resource : resources) {
            this.resource(resource, baseResource);
        }
        return this;
    }

    @NotNull
    public SuffixBuilder page(@NotNull Page page, @NotNull Page suffixBasePage) {
        return this.resource((Resource)AdaptTo.notNull((Adaptable)page, Resource.class), (Resource)AdaptTo.notNull((Adaptable)suffixBasePage, Resource.class));
    }

    @NotNull
    public SuffixBuilder pages(@NotNull List<Page> pages, @NotNull Page suffixBasePage) {
        List resources = Lists.transform(pages, page -> (Resource)page.adaptTo(Resource.class));
        return this.resources(resources, (Resource)AdaptTo.notNull((Adaptable)suffixBasePage, Resource.class));
    }

    @NotNull
    public String build() {
        String value;
        TreeMap<String, Object> sortedParameterMap = new TreeMap<String, Object>(this.parameterMap);
        TreeSet<String> resourcePathsSet = new TreeSet<String>();
        for (String nextPart : this.initialSuffixParts) {
            if (nextPart.indexOf(61) > 0) {
                String string = UrlSuffixUtil.decodeKey(nextPart);
                if (sortedParameterMap.containsKey(string)) continue;
                value = UrlSuffixUtil.decodeValue(nextPart);
                sortedParameterMap.put(string, value);
                continue;
            }
            String string = UrlSuffixUtil.decodeResourcePathPart(nextPart);
            if (this.resourcePaths.contains(string)) continue;
            resourcePathsSet.add(string);
        }
        if (this.resourcePaths != null) {
            resourcePathsSet.addAll((Collection<String>)ImmutableList.copyOf(this.resourcePaths));
        }
        ArrayList<String> suffixParts = new ArrayList<String>();
        for (String string : resourcePathsSet) {
            suffixParts.add(UrlSuffixUtil.encodeResourcePathPart(string));
        }
        for (Map.Entry entry : sortedParameterMap.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            String encodedKey = UrlSuffixUtil.encodeKeyValuePart((String)entry.getKey());
            String encodedValue = UrlSuffixUtil.encodeKeyValuePart(value.toString());
            suffixParts.add(encodedKey + '=' + encodedValue);
        }
        return StringUtils.join(suffixParts, (char)'/');
    }
}

