/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl.modes;

import io.wcm.handler.url.SiteConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;

class UrlConfig {
    private final String siteUrl;
    private final String siteUrlSecure;
    private final String siteUrlAuthor;

    UrlConfig(Adaptable adaptable) {
        SiteConfig config = (SiteConfig)adaptable.adaptTo(SiteConfig.class);
        if (config != null) {
            this.siteUrl = config.siteUrl();
            this.siteUrlSecure = StringUtils.defaultString((String)config.siteUrlSecure(), (String)this.siteUrl);
            this.siteUrlAuthor = config.siteUrlAuthor();
        } else {
            this.siteUrl = null;
            this.siteUrlSecure = null;
            this.siteUrlAuthor = null;
        }
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public String getSiteUrlSecure() {
        return this.siteUrlSecure;
    }

    public String getSiteUrlAuthor() {
        return this.siteUrlAuthor;
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.siteUrl);
    }

    public boolean hasSiteUrlAuthor() {
        return StringUtils.isNotEmpty((CharSequence)this.siteUrlAuthor);
    }
}

