/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.suffix;

import io.wcm.handler.url.suffix.SuffixStateKeepingStrategy;
import io.wcm.handler.url.suffix.impl.UrlSuffixUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class FilteringSuffixStateStrategy
implements SuffixStateKeepingStrategy {
    private final Predicate<String> suffixPartFilter;

    public FilteringSuffixStateStrategy(Predicate<String> suffixPartFilter) {
        this.suffixPartFilter = suffixPartFilter;
    }

    @Override
    @NotNull
    public List<String> getSuffixPartsToKeep(@NotNull SlingHttpServletRequest request) {
        String existingSuffix = request.getRequestPathInfo().getSuffix();
        String[] suffixPartArray = UrlSuffixUtil.splitSuffix(existingSuffix);
        ArrayList<String> suffixPartsToKeep = new ArrayList<String>();
        for (int i = 0; i < suffixPartArray.length; ++i) {
            String nextPart = suffixPartArray[i];
            if (this.suffixPartFilter != null && !this.suffixPartFilter.test(nextPart)) continue;
            suffixPartsToKeep.add(nextPart);
        }
        return suffixPartsToKeep;
    }
}

