/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.suffix;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import io.wcm.handler.url.suffix.impl.UrlSuffixUtil;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class SuffixParser {
    private final SlingHttpServletRequest request;

    public SuffixParser(@NotNull SlingHttpServletRequest request) {
        this.request = request;
    }

    public SuffixParser(@NotNull SlingHttpServletRequest request, @NotNull Predicate<String> suffixPartFilter) {
        this.request = request;
    }

    @Nullable
    public <T> T get(@NotNull String key, @NotNull Class<T> clazz) {
        if (clazz == String.class) {
            return (T)this.getString(key, null);
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(this.getBoolean(key, false));
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(this.getInt(key, 0));
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(this.getLong(key, 0L));
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz.getName());
    }

    @Nullable
    public <T> T get(@NotNull String key, @Nullable T defaultValue) {
        if (defaultValue instanceof String || defaultValue == null) {
            return (T)this.getString(key, (String)defaultValue);
        }
        if (defaultValue instanceof Boolean) {
            return (T)Boolean.valueOf(this.getBoolean(key, (Boolean)defaultValue));
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(this.getInt(key, (Integer)defaultValue));
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(this.getLong(key, (Long)defaultValue));
        }
        throw new IllegalArgumentException("Unsupported type: " + defaultValue.getClass().getName());
    }

    private String getString(String key, String defaultValue) {
        String value = this.findSuffixPartByKey(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        String value = this.findSuffixPartByKey(key);
        if (value == null) {
            return defaultValue;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    private int getInt(String key, int defaultValue) {
        String value = this.findSuffixPartByKey(key);
        if (value == null) {
            return defaultValue;
        }
        return NumberUtils.toInt((String)value, (int)defaultValue);
    }

    private long getLong(String key, long defaultValue) {
        String value = this.findSuffixPartByKey(key);
        if (value == null) {
            return defaultValue;
        }
        return NumberUtils.toLong((String)value, (long)defaultValue);
    }

    private String findSuffixPartByKey(String key) {
        for (String part : UrlSuffixUtil.splitSuffix(this.request.getRequestPathInfo().getSuffix())) {
            String partKey;
            if (part.indexOf(61) < 0 || !(partKey = UrlSuffixUtil.decodeKey(part)).equals(key)) continue;
            return UrlSuffixUtil.decodeValue(part);
        }
        return null;
    }

    @Nullable
    public Resource getResource() {
        return this.getResource(null, null);
    }

    @Nullable
    public Resource getResource(@NotNull Resource baseResource) {
        return this.getResource(null, baseResource);
    }

    @Nullable
    public Resource getResource(@NotNull Predicate<Resource> filter) {
        return this.getResource(filter, null);
    }

    @Nullable
    public Resource getResource(@Nullable Predicate<Resource> filter, @Nullable Resource baseResource) {
        List<Resource> suffixResources = this.getResources(filter, baseResource);
        if (suffixResources.isEmpty()) {
            return null;
        }
        return suffixResources.get(0);
    }

    @NotNull
    public List<Resource> getResources() {
        return this.getResources(null, null);
    }

    @NotNull
    public List<Resource> getResources(@NotNull Resource baseResource) {
        return this.getResources(null, baseResource);
    }

    @NotNull
    public List<Resource> getResources(@NotNull Predicate<Resource> filter) {
        return this.getResources(filter, null);
    }

    @NotNull
    public List<Resource> getResources(@Nullable Predicate<Resource> filter, @Nullable Resource baseResource) {
        Resource baseResourceToUse = baseResource;
        if (baseResourceToUse == null) {
            PageManager pageManager = (PageManager)this.request.getResourceResolver().adaptTo(PageManager.class);
            if (pageManager == null) {
                throw new RuntimeException("No page manager.");
            }
            Page currentPage = pageManager.getContainingPage(this.request.getResource());
            baseResourceToUse = currentPage != null ? currentPage.getContentResource() : this.request.getResource();
        }
        return this.getResourcesWithBaseResource(filter, baseResourceToUse);
    }

    @Nullable
    public Page getPage() {
        return this.getPage(null, null);
    }

    @Nullable
    public Page getPage(@NotNull Page basePage) {
        return this.getPage(null, basePage);
    }

    @Nullable
    public Page getPage(@NotNull Predicate<Page> filter) {
        return this.getPage(filter, null);
    }

    @Nullable
    public Page getPage(@Nullable Predicate<Page> filter, @Nullable Page basePage) {
        List<Page> suffixPages = this.getPages(filter, basePage);
        if (suffixPages.isEmpty()) {
            return null;
        }
        return suffixPages.get(0);
    }

    @NotNull
    public List<Page> getPages() {
        return this.getPages(null, null);
    }

    @NotNull
    public List<Page> getPages(@NotNull Predicate<Page> filter) {
        return this.getPages(filter, null);
    }

    @NotNull
    public List<Page> getPages(final @Nullable Predicate<Page> filter, @Nullable Page basePage) {
        Resource baseResourceToUse = null;
        if (basePage == null) {
            PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)this.request.getResourceResolver(), PageManager.class);
            Page currentPage = pageManager.getContainingPage(this.request.getResource());
            if (currentPage != null) {
                baseResourceToUse = (Resource)currentPage.adaptTo(Resource.class);
            }
        } else {
            baseResourceToUse = (Resource)basePage.adaptTo(Resource.class);
        }
        Predicate<Resource> resourceFilter = new Predicate<Resource>(){

            @Override
            public boolean test(Resource resource) {
                Page page = (Page)resource.adaptTo(Page.class);
                if (page == null) {
                    return false;
                }
                if (filter == null) {
                    return true;
                }
                return filter.test(page);
            }
        };
        List<Resource> resources = this.getResourcesWithBaseResource(resourceFilter, baseResourceToUse);
        return resources.stream().filter(Objects::nonNull).map(resource -> (Page)resource.adaptTo(Page.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private List<Resource> getResourcesWithBaseResource(@Nullable Predicate<Resource> filter, @Nullable Resource baseResource) {
        String[] suffixParts = UrlSuffixUtil.splitSuffix(this.request.getRequestPathInfo().getSuffix());
        ArrayList<Resource> selectedResources = new ArrayList<Resource>();
        for (String path : suffixParts) {
            if (StringUtils.contains((CharSequence)path, (int)61)) continue;
            String decodedPath = UrlSuffixUtil.decodeResourcePathPart(path);
            Resource resource = this.request.getResourceResolver().getResource(baseResource, decodedPath);
            if (resource == null || filter != null && !filter.test(resource)) continue;
            selectedResources.add(resource);
        }
        return selectedResources;
    }
}

