/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl;

import com.day.cq.wcm.api.Page;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.url.UrlBuilder;
import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.UrlMode;
import io.wcm.handler.url.impl.Externalizer;
import io.wcm.handler.url.impl.UrlBuilderImpl;
import io.wcm.handler.url.impl.clientlib.ClientlibProxyRewriter;
import io.wcm.handler.url.spi.UrlHandlerConfig;
import io.wcm.sling.commons.request.RequestParam;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.util.Path;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.settings.SlingSettingsService;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={UrlHandler.class})
public final class UrlHandlerImpl
implements UrlHandler {
    @Self
    private Adaptable self;
    @Self
    private UrlHandlerConfig urlHandlerConfig;
    @SlingObject
    private ResourceResolver resolver;
    @OSGiService
    private SlingSettingsService slingSettings;
    @OSGiService
    private ClientlibProxyRewriter clientlibProxyRewriter;
    @SlingObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private SlingHttpServletRequest request;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;

    @Override
    @NotNull
    public UrlBuilder get(@NotNull String path) {
        return new UrlBuilderImpl(path, this);
    }

    @Override
    @NotNull
    public UrlBuilder get(@NotNull Resource resource) {
        return new UrlBuilderImpl(resource, this);
    }

    @Override
    @NotNull
    public UrlBuilder get(@NotNull Page page) {
        return new UrlBuilderImpl(page, this);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public String rewritePathToContext(@NotNull Resource resource) {
        if (resource == null) {
            return null;
        }
        if (this.currentPage != null) {
            return this.rewritePathToContext(resource, (Resource)this.currentPage.adaptTo(Resource.class));
        }
        return resource.getPath();
    }

    @Override
    public String rewritePathToContext(@NotNull Resource resource, @NotNull Resource contextResource) {
        int i;
        if (resource == null) {
            return null;
        }
        if (contextResource == null) {
            return resource.getPath();
        }
        String[] contextPathParts = StringUtils.split((String)Path.getOriginalPath((String)contextResource.getPath(), (ResourceResolver)this.resolver), (String)"/");
        String[] pathParts = StringUtils.split((String)Path.getOriginalPath((String)resource.getPath(), (ResourceResolver)this.resolver), (String)"/");
        int siteRootLevelContextPath = this.urlHandlerConfig.getSiteRootLevel(contextResource);
        int siteRootLevelPath = this.urlHandlerConfig.getSiteRootLevel(resource);
        if (contextPathParts.length <= siteRootLevelContextPath || pathParts.length <= siteRootLevelPath || !StringUtils.equals((CharSequence)contextPathParts[0], (CharSequence)"content") || !StringUtils.equals((CharSequence)pathParts[0], (CharSequence)"content")) {
            return resource.getPath();
        }
        StringBuilder rewrittenPath = new StringBuilder();
        for (i = 0; i <= siteRootLevelContextPath; ++i) {
            rewrittenPath.append('/').append(contextPathParts[i]);
        }
        for (i = siteRootLevelPath + 1; i < pathParts.length; ++i) {
            rewrittenPath.append('/').append(pathParts[i]);
        }
        return rewrittenPath.toString();
    }

    String externalizeLinkUrl(String url, Page targetPage, UrlMode urlMode) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (Externalizer.isExternalized(url)) {
            return url;
        }
        String externalizedUrl = Externalizer.externalizeUrl(url, this.resolver, this.request);
        String linkUrlPrefix = this.getLinkUrlPrefix(urlMode, targetPage);
        externalizedUrl = StringUtils.defaultString((String)linkUrlPrefix) + externalizedUrl;
        return externalizedUrl;
    }

    private String getLinkUrlPrefix(UrlMode urlMode, Page targetPage) {
        UrlMode mode = (UrlMode)ObjectUtils.defaultIfNull((Object)urlMode, (Object)this.urlHandlerConfig.getDefaultUrlMode());
        return mode.getLinkUrlPrefix(this.self, this.slingSettings.getRunModes(), this.currentPage, targetPage);
    }

    String externalizeResourceUrl(String url, Resource targetResource, UrlMode urlMode) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (Externalizer.isExternalized(url) || !Externalizer.isExternalizable(url)) {
            return url;
        }
        Resource resource = targetResource;
        if (resource == null && StringUtils.startsWith((CharSequence)url, (CharSequence)"/content/")) {
            resource = this.resolver.resolve(url);
        }
        String externalizedUrl = this.clientlibProxyRewriter.rewriteStaticResourcePath(url);
        externalizedUrl = Externalizer.externalizeUrl(externalizedUrl, this.resolver, this.request);
        String resourceUrlPrefix = this.getResourceUrlPrefix(urlMode, resource);
        externalizedUrl = StringUtils.defaultString((String)resourceUrlPrefix) + externalizedUrl;
        return externalizedUrl;
    }

    private String getResourceUrlPrefix(UrlMode urlMode, Resource targetResource) {
        UrlMode mode = (UrlMode)ObjectUtils.defaultIfNull((Object)urlMode, (Object)this.urlHandlerConfig.getDefaultUrlMode());
        return mode.getResourceUrlPrefix(this.self, this.slingSettings.getRunModes(), this.currentPage, targetResource);
    }

    String buildUrl(String path, String selector, String extension, String suffix) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        StringBuilder extensionPart = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            extensionPart.append('.').append(extension);
        }
        StringBuilder selectorPart = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)selector)) {
            if (!StringUtils.startsWith((CharSequence)selector, (CharSequence)".")) {
                selectorPart.append('.');
            }
            selectorPart.append(selector);
        }
        StringBuilder suffixPart = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            if (!StringUtils.startsWith((CharSequence)suffix, (CharSequence)"/")) {
                suffixPart = suffixPart.append("/");
            }
            suffixPart.append(suffix);
            if (!StringUtils.contains((CharSequence)suffix, (CharSequence)".")) {
                suffixPart.append((CharSequence)extensionPart);
            }
            selectorPart.append('.').append("suffix");
        }
        return path + selectorPart.toString() + extensionPart.toString() + suffixPart.toString();
    }

    String appendQueryString(String url, String queryString, Set<String> inheritableParameterNames) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder();
        StringBuilder queryParams = new StringBuilder();
        int separatorPos = url.indexOf(63);
        if (separatorPos >= 0) {
            queryParams.append(url.substring(separatorPos + 1));
            urlBuilder.append(url.substring(0, separatorPos));
        } else {
            urlBuilder.append(url);
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            if (queryParams.length() > 0) {
                queryParams.append('&');
            }
            queryParams.append(queryString);
        }
        if (inheritableParameterNames != null && this.request != null) {
            for (String parameterName : inheritableParameterNames) {
                String[] values;
                if (queryParams.indexOf(parameterName + "=") != -1 || (values = RequestParam.getMultiple((ServletRequest)this.request, (String)parameterName)) == null) continue;
                for (String value : values) {
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    if (queryParams.length() > 0) {
                        queryParams.append('&');
                    }
                    queryParams.append(parameterName);
                    queryParams.append('=');
                    queryParams.append(value);
                }
            }
        }
        if (queryParams.length() > 0) {
            urlBuilder.append('?');
            urlBuilder.append((CharSequence)queryParams);
        }
        return urlBuilder.toString();
    }

    String setFragment(String url, String fragment) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        int index = url.indexOf(35);
        StringBuilder urlBuilder = index >= 0 ? new StringBuilder(url.substring(0, index)) : new StringBuilder(url);
        if (StringUtils.isNotBlank((CharSequence)fragment)) {
            if (!StringUtils.startsWith((CharSequence)fragment, (CharSequence)"#")) {
                urlBuilder.append('#');
            }
            urlBuilder.append(fragment);
        }
        return urlBuilder.toString();
    }
}

