/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl.clientlib;

import io.wcm.handler.url.impl.clientlib.ClientlibPathCache;
import io.wcm.handler.url.impl.clientlib.ClientlibProxyRewriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ClientlibProxyRewriter.class}, immediate=true)
public class ClientlibProxyRewriterImpl
implements ClientlibProxyRewriter {
    private static final Pattern STATIC_RESOURCE_PATH_PATTERN = Pattern.compile("^(/(apps|libs)/.*)/resources/.*$");
    private static final Logger log = LoggerFactory.getLogger(ClientlibProxyRewriterImpl.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private volatile ClientlibPathCache clientlibPathCache;

    @Deactivate
    private void deactivate() throws Exception {
        if (this.clientlibPathCache != null) {
            this.clientlibPathCache.close();
        }
        this.clientlibPathCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientlibPathCache getClientlibPathCache() {
        if (this.clientlibPathCache == null) {
            ClientlibProxyRewriterImpl clientlibProxyRewriterImpl = this;
            synchronized (clientlibProxyRewriterImpl) {
                if (this.clientlibPathCache == null) {
                    this.clientlibPathCache = new ClientlibPathCache(this.resourceResolverFactory);
                }
            }
        }
        return this.clientlibPathCache;
    }

    @Override
    @NotNull
    public String rewriteStaticResourcePath(@NotNull String path) {
        Matcher matcher = STATIC_RESOURCE_PATH_PATTERN.matcher(path);
        if (matcher.matches()) {
            String clientlibPath = matcher.group(1);
            boolean clientlibProxyMode = this.getClientlibPathCache().isClientlibWithAllowProxy(clientlibPath);
            if (clientlibProxyMode) {
                return this.rewriteClientlibProxyPath(path);
            }
        }
        return path;
    }

    private String rewriteClientlibProxyPath(String path) {
        String rewrittenPath = "/etc.clientlibs" + path.substring(5);
        log.debug("Rewrite {} to {}", (Object)path, (Object)rewrittenPath);
        return rewrittenPath;
    }
}

