/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.integrator.impl;

import com.day.cq.wcm.api.Page;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.url.integrator.IntegratorHandler;
import io.wcm.handler.url.integrator.IntegratorMode;
import io.wcm.handler.url.integrator.IntegratorProtocol;
import io.wcm.handler.url.spi.UrlHandlerConfig;
import io.wcm.sling.commons.request.RequestPath;
import io.wcm.sling.models.annotations.AemObject;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={IntegratorHandler.class})
public final class IntegratorHandlerImpl
implements IntegratorHandler {
    @Self
    private UrlHandlerConfig urlHandlerConfig;
    @SlingObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private SlingHttpServletRequest request;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;
    private boolean integratorTemplateMode;
    private boolean integratorTemplateSecureMode;

    @PostConstruct
    private void postConstruct() {
        this.detectIntegratorTemplateModes();
    }

    private void detectIntegratorTemplateModes() {
        if (this.urlHandlerConfig.getIntegratorModes().isEmpty()) {
            return;
        }
        if (this.request != null && RequestPath.hasSelector((SlingHttpServletRequest)this.request, (String)"integratortemplatesecure")) {
            this.integratorTemplateSecureMode = true;
        } else if (this.request != null && RequestPath.hasSelector((SlingHttpServletRequest)this.request, (String)"integratortemplate")) {
            this.integratorTemplateMode = true;
        }
    }

    @Override
    public boolean isIntegratorTemplateMode() {
        return this.integratorTemplateMode || this.integratorTemplateSecureMode;
    }

    @Override
    public boolean isIntegratorTemplateSecureMode() {
        return this.integratorTemplateSecureMode;
    }

    @Override
    @NotNull
    public String getIntegratorTemplateSelector() {
        if (this.currentPage != null && this.urlHandlerConfig.isIntegrator(this.currentPage)) {
            if (this.isResourceUrlSecure(this.currentPage)) {
                return "integratortemplatesecure";
            }
            return "integratortemplate";
        }
        if (this.integratorTemplateSecureMode) {
            return "integratortemplatesecure";
        }
        return "integratortemplate";
    }

    @Override
    @NotNull
    public IntegratorMode getIntegratorMode() {
        return this.getIntegratorMode(this.currentPage);
    }

    @Override
    @NotNull
    public IntegratorMode getIntegratorMode(@Nullable Page page) {
        ValueMap props = IntegratorHandlerImpl.getPagePropertiesNullSafe(page);
        return this.getIntegratorMode(props);
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    @NotNull
    private IntegratorMode getIntegratorMode(ValueMap properties) {
        IntegratorMode mode = null;
        Collection<IntegratorMode> integratorModes = this.urlHandlerConfig.getIntegratorModes();
        String modeString = (String)properties.get("integratorMode", String.class);
        if (StringUtils.isNotEmpty((CharSequence)modeString)) {
            for (IntegratorMode candidate : integratorModes) {
                if (!StringUtils.equals((CharSequence)modeString, (CharSequence)candidate.getId())) continue;
                mode = candidate;
                break;
            }
        }
        if (mode == null && !integratorModes.isEmpty()) {
            mode = integratorModes.iterator().next();
        }
        return mode;
    }

    private IntegratorProtocol getIntegratorProtocol(ValueMap properties) {
        IntegratorProtocol protocol = IntegratorProtocol.AUTO;
        try {
            String protocolString = (String)properties.get("integratorProtocol", String.class);
            if (StringUtils.isNotEmpty((CharSequence)protocolString)) {
                protocol = IntegratorProtocol.valueOf(protocolString.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return protocol;
    }

    private boolean isResourceUrlSecure(Page page) {
        ValueMap props = IntegratorHandlerImpl.getPagePropertiesNullSafe(page);
        IntegratorMode mode = this.getIntegratorMode(props);
        if (mode.isDetectProtocol()) {
            IntegratorProtocol integratorProtocol = this.getIntegratorProtocol(props);
            if (integratorProtocol == IntegratorProtocol.HTTPS) {
                return true;
            }
            if (integratorProtocol == IntegratorProtocol.AUTO) {
                return RequestPath.hasSelector((SlingHttpServletRequest)this.request, (String)"integratortemplatesecure");
            }
        }
        return false;
    }

    private static ValueMap getPagePropertiesNullSafe(Page page) {
        if (page != null) {
            return page.getProperties();
        }
        return ValueMap.EMPTY;
    }
}

