/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.url.UrlBuilder;
import io.wcm.handler.url.UrlMode;
import io.wcm.handler.url.VanityMode;
import io.wcm.handler.url.impl.UrlHandlerImpl;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UrlBuilderImpl
implements UrlBuilder {
    private final UrlHandlerImpl urlHandler;
    private final String path;
    private final Resource resource;
    private final Page page;
    private String selectors;
    private String extension;
    private String suffix;
    private String queryString;
    private Set<String> inheritableParameterNames;
    private String fragment;
    private UrlMode urlMode;
    private VanityMode vanityMode;
    private boolean disableSuffixSelector;

    UrlBuilderImpl(String path, UrlHandlerImpl urlHandler) {
        this.path = path;
        this.resource = null;
        this.page = null;
        this.urlHandler = urlHandler;
    }

    UrlBuilderImpl(Resource resource, UrlHandlerImpl urlHandler) {
        this.path = resource != null ? resource.getPath() : null;
        this.resource = resource;
        this.page = null;
        this.urlHandler = urlHandler;
    }

    UrlBuilderImpl(Page page, UrlHandlerImpl urlHandler) {
        this.path = page != null ? page.getPath() : null;
        this.resource = null;
        this.page = page;
        this.urlHandler = urlHandler;
    }

    @Override
    @NotNull
    public UrlBuilder selectors(@Nullable String value) {
        this.selectors = value;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder extension(@Nullable String value) {
        this.extension = value;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder suffix(@Nullable String value) {
        this.suffix = value;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder queryString(@Nullable String value) {
        this.queryString = value;
        this.inheritableParameterNames = null;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder queryString(@Nullable String value, @NotNull Set<String> inheritableParamNames) {
        this.queryString = value;
        this.inheritableParameterNames = inheritableParamNames;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder fragment(@Nullable String value) {
        this.fragment = value;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder urlMode(@Nullable UrlMode value) {
        this.urlMode = value;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder vanityMode(@Nullable VanityMode value) {
        this.vanityMode = value;
        return this;
    }

    @Override
    @NotNull
    public UrlBuilder disableSuffixSelector(boolean value) {
        this.disableSuffixSelector = value;
        return this;
    }

    private String build(boolean externalize) {
        String pathToUse = this.path;
        VanityMode vanityModeToUse = (VanityMode)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.vanityMode), (Object)((Object)this.urlHandler.getDefaultVanityMode())));
        if (this.page != null && (vanityModeToUse == VanityMode.ALWAYS || externalize && vanityModeToUse == VanityMode.EXTERNALIZE)) {
            pathToUse = StringUtils.defaultString((String)this.page.getVanityUrl(), (String)this.path);
        }
        String url = this.urlHandler.buildUrl(pathToUse, this.selectors, this.extension, this.suffix, this.disableSuffixSelector);
        if (StringUtils.isNotEmpty((CharSequence)this.queryString) || this.inheritableParameterNames != null) {
            url = this.urlHandler.appendQueryString(url, this.queryString, this.inheritableParameterNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.fragment)) {
            url = this.urlHandler.setFragment(url, this.fragment);
        }
        return url;
    }

    @Override
    public String build() {
        return this.build(false);
    }

    @Override
    public String buildExternalLinkUrl() {
        return this.buildExternalLinkUrl(null);
    }

    @Override
    public String buildExternalLinkUrl(@Nullable Page targetPage) {
        Page targetPageToUse = targetPage;
        if (targetPageToUse == null) {
            targetPageToUse = this.page;
        }
        if (targetPageToUse == null && this.resource != null) {
            targetPageToUse = (Page)this.resource.adaptTo(Page.class);
        }
        String url = this.build(true);
        return this.urlHandler.externalizeLinkUrl(url, targetPageToUse, this.urlMode);
    }

    @Override
    public String buildExternalResourceUrl() {
        return this.buildExternalResourceUrl(null);
    }

    @Override
    public String buildExternalResourceUrl(@Nullable Resource targetResource) {
        Resource targetResourceToUse = targetResource;
        if (targetResourceToUse == null) {
            targetResourceToUse = this.resource;
        }
        if (targetResourceToUse == null && this.page != null) {
            targetResourceToUse = (Resource)this.page.adaptTo(Resource.class);
        }
        String url = this.build(true);
        return this.urlHandler.externalizeResourceUrl(url, targetResourceToUse, this.urlMode);
    }
}

