/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.rewriter.impl;

import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.rewriter.impl.UrlExternalizerTransformerConfig;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.cocoon.xml.sax.AbstractSAXPipe;
import org.apache.cocoon.xml.sax.AttributesImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class UrlExternalizerTransformer
extends AbstractSAXPipe
implements Transformer {
    private UrlExternalizerTransformerConfig transformerConfig;
    private UrlHandler urlHandler;
    private static final Logger log = LoggerFactory.getLogger((String)UrlExternalizerTransformer.class.getName());

    UrlExternalizerTransformer() {
    }

    public void init(ProcessingContext pipelineContext, ProcessingComponentConfiguration config) {
        log.trace("Initialize UrlExternalizerTransformer with config: {}", (Object)config.getConfiguration());
        this.transformerConfig = new UrlExternalizerTransformerConfig(config.getConfiguration());
        this.urlHandler = (UrlHandler)pipelineContext.getRequest().adaptTo(UrlHandler.class);
    }

    public void startElement(String nsUri, String name, String raw, Attributes attrs) throws SAXException {
        String rewriteAttr = this.transformerConfig.getElementAttributeNames().get(name);
        if (rewriteAttr == null) {
            log.trace("Rewrite element {}: Skip - No rewrite attribute configured.", (Object)name);
            super.startElement(nsUri, name, raw, attrs);
            return;
        }
        if (this.urlHandler == null) {
            log.warn("Rewrite element {}: Skip - Unable to get URL handler/Integrator handler instance.", (Object)name);
            super.startElement(nsUri, name, raw, attrs);
            return;
        }
        int attributeIndex = attrs.getIndex(rewriteAttr);
        if (attributeIndex < 0) {
            log.trace("Rewrite element {}: Skip - Attribute does not exist: {}", (Object)name, (Object)rewriteAttr);
            super.startElement(nsUri, name, raw, attrs);
            return;
        }
        String url = attrs.getValue(attributeIndex);
        if (StringUtils.isEmpty((CharSequence)url)) {
            log.trace("Rewrite element {}: Skip - URL is empty.", (Object)name);
            super.startElement(nsUri, name, raw, attrs);
            return;
        }
        String urlRemainder = null;
        int urlRemainderPos = StringUtils.indexOfAny((CharSequence)url, (char[])new char[]{'?', '#'});
        if (urlRemainderPos >= 0) {
            urlRemainder = url.substring(urlRemainderPos);
            url = url.substring(0, urlRemainderPos);
        }
        url = URLDecoder.decode(url, StandardCharsets.UTF_8);
        Object rewrittenUrl = this.urlHandler.get(url).buildExternalResourceUrl();
        if (urlRemainder != null) {
            rewrittenUrl = rewrittenUrl == null ? urlRemainder : (String)rewrittenUrl + urlRemainder;
        }
        if (StringUtils.equals((CharSequence)url, (CharSequence)rewrittenUrl)) {
            log.debug("Rewrite element {}: Skip - URL is already externalized: {}", (Object)name, (Object)url);
            super.startElement(nsUri, name, raw, attrs);
            return;
        }
        log.debug("Rewrite element {}: Rewrite URL {} to {}", new Object[]{name, url, rewrittenUrl});
        AttributesImpl newAttrs = new AttributesImpl(attrs);
        newAttrs.setValue(attributeIndex, (String)rewrittenUrl);
        super.startElement(nsUri, name, raw, (Attributes)newAttrs);
    }

    public void dispose() {
    }
}

