/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl;

import io.wcm.sling.commons.util.Escape;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Externalizer {
    private static final Pattern EXTERNALIZED_PATTERN = Pattern.compile("^([^/]+:|//|#).+?");
    private static final String MANGLED_NAMESPACE_PREFIX = "/_";
    private static final String MANGLED_NAMESPACE_SUFFIX = "_";
    private static final char NAMESPACE_SEPARATOR = ':';
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("/([^:/]+):");

    private Externalizer() {
    }

    @Nullable
    public static String externalizeUrl(@NotNull String url, @NotNull ResourceResolver resolver, @Nullable SlingHttpServletRequest request) {
        return Externalizer.externalizeUrlWithSlingMapping(url, resolver, request, false);
    }

    @Nullable
    public static String externalizeUrlWithHost(@NotNull String url, @NotNull ResourceResolver resolver, @Nullable SlingHttpServletRequest request) {
        return Externalizer.externalizeUrlWithSlingMapping(url, resolver, request, true);
    }

    @Nullable
    private static String externalizeUrlWithSlingMapping(@NotNull String url, @NotNull ResourceResolver resolver, @Nullable SlingHttpServletRequest request, boolean keepHost) {
        String path = url;
        String urlRemainder = null;
        int urlRemainderPos = StringUtils.indexOfAny((CharSequence)path, (char[])new char[]{'?', '#'});
        if (urlRemainderPos >= 0) {
            urlRemainder = path.substring(urlRemainderPos);
            path = path.substring(0, urlRemainderPos);
        }
        path = request != null ? resolver.map((HttpServletRequest)request, path) : resolver.map(path);
        if (!keepHost) {
            try {
                path = new URI(path).getRawPath();
                path = StringUtils.replace((String)path, (String)"%2F", (String)"/");
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Sling map method returned invalid URI: " + path, ex);
            }
        }
        if (path == null) {
            return null;
        }
        return path + (urlRemainder != null ? urlRemainder : "");
    }

    @NotNull
    public static String externalizeUrlWithoutMapping(@NotNull String url, @Nullable SlingHttpServletRequest request) {
        Object path = url;
        String urlRemainder = null;
        int urlRemainderPos = StringUtils.indexOfAny((CharSequence)path, (char[])new char[]{'?', '#'});
        if (urlRemainderPos >= 0) {
            urlRemainder = ((String)path).substring(urlRemainderPos);
            path = ((String)path).substring(0, urlRemainderPos);
        }
        path = Externalizer.mangleNamespaces((String)path);
        if (request != null) {
            path = StringUtils.defaultString((String)request.getContextPath()) + (String)path;
        }
        path = Escape.urlEncode((String)path);
        path = StringUtils.replace((String)path, (String)"+", (String)"%20");
        path = StringUtils.replace((String)path, (String)"%2F", (String)"/");
        return (String)path + (urlRemainder != null ? urlRemainder : "");
    }

    public static boolean isExternalized(@NotNull String url) {
        return EXTERNALIZED_PATTERN.matcher(url).matches();
    }

    public static boolean isExternalizable(@NotNull String url) {
        return StringUtils.startsWith((CharSequence)url, (CharSequence)"/");
    }

    @NotNull
    public static String mangleNamespaces(@NotNull String path) {
        if (!StringUtils.contains((CharSequence)path, (int)58)) {
            return path;
        }
        Matcher matcher = NAMESPACE_PATTERN.matcher(path);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = MANGLED_NAMESPACE_PREFIX + matcher.group(1) + MANGLED_NAMESPACE_SUFFIX;
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

