/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl;

import io.wcm.handler.url.SiteRootDetector;
import io.wcm.handler.url.shaded.com.github.benmanes.caffeine.cache.Cache;
import io.wcm.handler.url.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import io.wcm.wcm.commons.util.Path;
import java.util.concurrent.TimeUnit;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SiteRootDetector.class})
public class SiteRootDetectorImpl
implements SiteRootDetector {
    private static final int INVALID_SITE_ROOT_LEVEL = -1;
    @Reference
    private ConfigurationResourceResolver configurationResourceResolver;
    private static final Logger log = LoggerFactory.getLogger(SiteRootDetectorImpl.class);
    private final Cache<String, Integer> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(10000L).build();

    @Override
    public int getSiteRootLevel(@Nullable Resource contextResource) {
        if (contextResource == null) {
            return -1;
        }
        return this.cache.get(contextResource.getPath(), path -> this.detectSiteRootLevel(contextResource));
    }

    private int detectSiteRootLevel(@Nullable Resource contextResource) {
        String siteRootpath;
        if (contextResource != null && (siteRootpath = this.configurationResourceResolver.getContextPath(contextResource)) != null) {
            int level = Path.getAbsoluteLevel((String)siteRootpath, (ResourceResolver)contextResource.getResourceResolver());
            if (log.isDebugEnabled()) {
                log.debug("Detect site root level for {}: {}", (Object)contextResource.getPath(), (Object)level);
            }
            return level;
        }
        return -1;
    }
}

