/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl;

import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UrlPrefix {
    public static final String AUTO_DETECTION = "<auto>";
    static final String HTTP_HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    static final String HTTP_HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    static final String HTTP_HEADER_HOST = "Host";
    static final String HTTP_HEADER_X_FORWARDED_SSL = "X-Forwarded-SSL";
    static final String VALUE_ON = "on";
    private static final Logger log = LoggerFactory.getLogger(UrlPrefix.class);

    private UrlPrefix() {
    }

    @Nullable
    static String applyAutoDetection(@Nullable String configuredUrlPrefix, @NotNull Adaptable adaptable) {
        String urlPrefix = configuredUrlPrefix;
        if (StringUtils.contains((CharSequence)configuredUrlPrefix, (CharSequence)AUTO_DETECTION)) {
            SlingHttpServletRequest request;
            urlPrefix = StringUtils.trimToNull((String)StringUtils.remove((String)configuredUrlPrefix, (String)AUTO_DETECTION));
            if (adaptable instanceof SlingHttpServletRequest && (urlPrefix = UrlPrefix.detectFromForwardedHeader(request = (SlingHttpServletRequest)adaptable)) == null) {
                urlPrefix = UrlPrefix.detectFromServletRequest(request);
            }
        }
        return urlPrefix;
    }

    @Nullable
    private static String detectFromForwardedHeader(@NotNull SlingHttpServletRequest request) {
        if (log.isTraceEnabled()) {
            StringBuilder output = new StringBuilder();
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                if (output.length() > 0) {
                    output.append("; ");
                }
                output.append(header).append('=').append(request.getHeader(header));
            }
            log.trace("HTTP headers: {}", (Object)output);
        }
        String forwardedHost = request.getHeader(HTTP_HEADER_X_FORWARDED_HOST);
        String forwardedProto = request.getHeader(HTTP_HEADER_X_FORWARDED_PROTO);
        if (StringUtils.isNotEmpty((CharSequence)forwardedHost) && StringUtils.isNotEmpty((CharSequence)forwardedProto)) {
            return forwardedProto + "://" + forwardedHost;
        }
        String host = request.getHeader(HTTP_HEADER_HOST);
        String forwardedSsl = request.getHeader(HTTP_HEADER_X_FORWARDED_SSL);
        if (StringUtils.isNotEmpty((CharSequence)host) && StringUtils.equalsIgnoreCase((CharSequence)forwardedSsl, (CharSequence)VALUE_ON)) {
            return "https://" + host;
        }
        return null;
    }

    @NotNull
    private static String detectFromServletRequest(@NotNull SlingHttpServletRequest request) {
        StringBuilder urlPrefix = new StringBuilder();
        urlPrefix.append(request.getScheme()).append("://").append(request.getServerName());
        int port = request.getServerPort();
        if (request.isSecure() && port != 443 || !request.isSecure() && port != 80) {
            urlPrefix.append(':').append(Integer.toString(port));
        }
        return urlPrefix.toString();
    }
}

