/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl.clientlib;

import io.wcm.handler.url.impl.clientlib.ClientlibPathCacheEntry;
import io.wcm.handler.url.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import io.wcm.handler.url.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.api.observation.JackrabbitObservationManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientlibPathCache
implements EventListener,
AutoCloseable {
    private final ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver listenerServiceResourceResolver;
    private static final String NT_CLIENTLIBRARY = "cq:ClientLibraryFolder";
    private static final String PN_ALLOWPROXY = "allowProxy";
    private static final String CLIENTLIBS_SERVICE = "clientlibs-service";
    private static final String SERVICE_USER_MAPPING_WARNING = "Missing service user mapping for 'io.wcm.handler.url:clientlibs-service' - see https://wcm.io/handler/url/configuration.html";
    private final LoadingCache<String, ClientlibPathCacheEntry> cache = Caffeine.newBuilder().maximumSize(10000L).build(path -> {
        try (ResourceResolver resourceResolver = this.getServiceResourceResolver();){
            Resource resource = resourceResolver.getResource(path);
            if (resource == null) return new ClientlibPathCacheEntry((String)path, false, false);
            Node node = (Node)resource.adaptTo(Node.class);
            if (node == null) return new ClientlibPathCacheEntry((String)path, false, false);
            if (!node.isNodeType(NT_CLIENTLIBRARY)) return new ClientlibPathCacheEntry((String)path, false, false);
            boolean isAllowProxy = (Boolean)resource.getValueMap().get(PN_ALLOWPROXY, (Object)false);
            ClientlibPathCacheEntry entry = new ClientlibPathCacheEntry((String)path, true, isAllowProxy);
            log.debug("Detected client library: {}", (Object)entry);
            ClientlibPathCacheEntry clientlibPathCacheEntry = entry;
            return clientlibPathCacheEntry;
        }
        catch (LoginException ex) {
            log.warn(SERVICE_USER_MAPPING_WARNING);
        }
        return new ClientlibPathCacheEntry((String)path, false, false);
    });
    private static final Logger log = LoggerFactory.getLogger(ClientlibPathCache.class);

    ClientlibPathCache(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
        try {
            this.listenerServiceResourceResolver = this.getServiceResourceResolver();
            this.enableObservationForClientLibraries();
        }
        catch (LoginException ex) {
            log.warn(SERVICE_USER_MAPPING_WARNING);
        }
    }

    private ResourceResolver getServiceResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", CLIENTLIBS_SERVICE));
    }

    private void enableObservationForClientLibraries() {
        Session session = (Session)this.listenerServiceResourceResolver.adaptTo(Session.class);
        if (session != null) {
            try {
                log.debug("Enable observation for client libraries.");
                JackrabbitObservationManager observationManager = (JackrabbitObservationManager)session.getWorkspace().getObservationManager();
                JackrabbitEventFilter eventFilter = new JackrabbitEventFilter().setEventTypes(63).setAbsPath("/apps").setAdditionalPaths(new String[]{"/apps", "/libs"}).setIsDeep(true).setNodeTypes(new String[]{NT_CLIENTLIBRARY});
                observationManager.addEventListener((EventListener)this, eventFilter);
            }
            catch (RepositoryException ex) {
                log.warn("Unable to register obervation for client libraries.");
            }
        }
    }

    public void onEvent(EventIterator events) {
        log.debug("Clear client library path cache.");
        this.cache.invalidateAll();
    }

    public boolean isClientlibWithAllowProxy(String path) {
        ClientlibPathCacheEntry entry = this.cache.get(path);
        return entry.isClientLibrary() && entry.isAllowProxy();
    }

    @Override
    public void close() {
        if (this.listenerServiceResourceResolver != null) {
            log.debug("End observation for client libraries.");
            this.listenerServiceResourceResolver.close();
        }
    }
}

