/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl.modes;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.url.UrlModes;
import io.wcm.handler.url.impl.modes.AbstractUrlMode;
import io.wcm.handler.url.impl.modes.UrlConfig;
import io.wcm.handler.url.integrator.IntegratorHandler;
import io.wcm.handler.url.spi.UrlHandlerConfig;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.util.Path;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultUrlMode
extends AbstractUrlMode {
    @Override
    @NotNull
    public String getId() {
        return "DEFAULT";
    }

    @Override
    public String getLinkUrlPrefix(@NotNull Adaptable adaptable, @NotNull Set<String> runModes, @Nullable Page currentPage, @Nullable Page targetPage) {
        return UrlModes.FULL_URL.getLinkUrlPrefix(adaptable, runModes, currentPage, targetPage);
    }

    @Override
    public String getResourceUrlPrefix(@NotNull Adaptable adaptable, @NotNull Set<String> runModes, @Nullable Page currentPage, @Nullable Resource targetResource) {
        IntegratorHandler integratorHandler = (IntegratorHandler)AdaptTo.notNull((Adaptable)adaptable, IntegratorHandler.class);
        if (integratorHandler.isIntegratorTemplateMode() || this.linksToOtherDomain(adaptable, currentPage, targetResource)) {
            return UrlModes.FULL_URL.getResourceUrlPrefix(adaptable, runModes, currentPage, targetResource);
        }
        return UrlModes.NO_HOSTNAME.getResourceUrlPrefix(adaptable, runModes, currentPage, targetResource);
    }

    private boolean linksToOtherDomain(Adaptable adaptable, Page currentPage, Resource targetResource) {
        String pathSiteRoot;
        boolean notInCurrentSite;
        if (currentPage == null || targetResource == null) {
            return false;
        }
        UrlHandlerConfig urlHandlerConfig = (UrlHandlerConfig)AdaptTo.notNull((Adaptable)adaptable, UrlHandlerConfig.class);
        Resource currentResource = (Resource)AdaptTo.notNull((Adaptable)currentPage, Resource.class);
        ResourceResolver resourceResolver = currentResource.getResourceResolver();
        String currentSiteRoot = this.getRootPath(currentPage.getPath(), urlHandlerConfig.getSiteRootLevel(currentResource), resourceResolver);
        boolean bl = notInCurrentSite = !StringUtils.equals((CharSequence)currentSiteRoot, (CharSequence)(pathSiteRoot = this.getRootPath(targetResource.getPath(), urlHandlerConfig.getSiteRootLevel(targetResource), resourceResolver)));
        if (notInCurrentSite) {
            UrlConfig targetUrlConfig = new UrlConfig((Adaptable)targetResource);
            return targetUrlConfig.isValid();
        }
        return false;
    }

    private String getRootPath(String path, int rootLevel, ResourceResolver resourceResolver) {
        String rootPath = Path.getAbsoluteParent((String)path, (int)rootLevel, (ResourceResolver)resourceResolver);
        if (StringUtils.contains((CharSequence)rootPath, (CharSequence)".")) {
            rootPath = StringUtils.substringBefore((String)rootPath, (String)".");
        }
        return rootPath;
    }
}

