/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.impl.modes;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.url.impl.modes.AbstractUrlMode;
import io.wcm.handler.url.impl.modes.UrlConfig;
import io.wcm.handler.url.integrator.IntegratorHandler;
import io.wcm.handler.url.spi.UrlHandlerConfig;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.util.RunMode;
import java.util.Set;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FullUrlUrlMode
extends AbstractUrlMode {
    private final boolean forcePublish;

    public FullUrlUrlMode(boolean forcePublish) {
        this.forcePublish = forcePublish;
    }

    @Override
    @NotNull
    public String getId() {
        return "FULL_URL";
    }

    @Override
    public String getLinkUrlPrefix(@NotNull Adaptable adaptable, @NotNull Set<String> runModes, @Nullable Page currentPage, @Nullable Page targetPage) {
        UrlHandlerConfig urlHandlerConfig = (UrlHandlerConfig)AdaptTo.notNull((Adaptable)adaptable, UrlHandlerConfig.class);
        IntegratorHandler integratorHandler = (IntegratorHandler)AdaptTo.notNull((Adaptable)adaptable, IntegratorHandler.class);
        if (integratorHandler.isIntegratorTemplateMode() && integratorHandler.getIntegratorMode().isUseUrlPlaceholders()) {
            if (targetPage != null && urlHandlerConfig.isSecure(targetPage)) {
                return "###URL_CONTENT_SECURE###";
            }
            return "###URL_CONTENT###";
        }
        UrlConfig config = this.getUrlConfigForTarget(adaptable, targetPage);
        if (!this.forcePublish && RunMode.isAuthor(runModes) && config.hasSiteUrlAuthor()) {
            return config.getSiteUrlAuthor();
        }
        if (targetPage != null && urlHandlerConfig.isSecure(targetPage)) {
            return config.getSiteUrlSecure();
        }
        return config.getSiteUrl();
    }

    @Override
    public String getResourceUrlPrefix(@NotNull Adaptable adaptable, @NotNull Set<String> runModes, @Nullable Page currentPage, @Nullable Resource targetResource) {
        IntegratorHandler integratorHandler = (IntegratorHandler)AdaptTo.notNull((Adaptable)adaptable, IntegratorHandler.class);
        if (integratorHandler.isIntegratorTemplateMode() && integratorHandler.getIntegratorMode().isUseUrlPlaceholders()) {
            return "###URL_CONTENT_PROXY###";
        }
        UrlConfig config = this.getUrlConfigForTarget(adaptable, targetResource);
        if (!this.forcePublish && RunMode.isAuthor(runModes) && config.hasSiteUrlAuthor()) {
            return config.getSiteUrlAuthor();
        }
        UrlHandlerConfig urlHandlerConfig = (UrlHandlerConfig)AdaptTo.notNull((Adaptable)adaptable, UrlHandlerConfig.class);
        if (currentPage != null && urlHandlerConfig.isSecure(currentPage) || integratorHandler.isIntegratorTemplateSecureMode()) {
            return config.getSiteUrlSecure();
        }
        return config.getSiteUrl();
    }
}

