/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.rewriter.impl;

import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.rewriter.impl.UrlExternalizerTransformerConfig;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class UrlExternalizerTransformer
implements Transformer {
    private UrlExternalizerTransformerConfig transformerConfig;
    private ContentHandler contentHandler = EMPTY_CONTENT_HANDLER;
    private UrlHandler urlHandler;
    private static final Logger log = LoggerFactory.getLogger((String)UrlExternalizerTransformer.class.getName());
    private static final ContentHandler EMPTY_CONTENT_HANDLER = new DefaultHandler();

    UrlExternalizerTransformer() {
    }

    public void init(ProcessingContext pipelineContext, ProcessingComponentConfiguration config) {
        log.trace("Initialize UrlExternalizerTransformer with config: {}", (Object)config.getConfiguration());
        this.transformerConfig = new UrlExternalizerTransformerConfig(config.getConfiguration());
        this.urlHandler = (UrlHandler)pipelineContext.getRequest().adaptTo(UrlHandler.class);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void startElement(String nsUri, String name, String raw, Attributes attrs) throws SAXException {
        String rewriteAttr = this.transformerConfig.getElementAttributeNames().get(name);
        if (rewriteAttr == null) {
            log.trace("Rewrite element {}: Skip - No rewrite attribute configured.", (Object)name);
            this.contentHandler.startElement(nsUri, name, raw, attrs);
            return;
        }
        if (this.urlHandler == null) {
            log.warn("Rewrite element {}: Skip - Unable to get URL handler/Integrator handler instance.", (Object)name);
            this.contentHandler.startElement(nsUri, name, raw, attrs);
            return;
        }
        int attributeIndex = attrs.getIndex(rewriteAttr);
        if (attributeIndex < 0) {
            log.trace("Rewrite element {}: Skip - Attribute does not exist: {}", (Object)name, (Object)rewriteAttr);
            this.contentHandler.startElement(nsUri, name, raw, attrs);
            return;
        }
        String url = attrs.getValue(attributeIndex);
        if (StringUtils.isEmpty((CharSequence)url)) {
            log.trace("Rewrite element {}: Skip - URL is empty.", (Object)name);
            this.contentHandler.startElement(nsUri, name, raw, attrs);
            return;
        }
        String urlRemainder = null;
        int urlRemainderPos = StringUtils.indexOfAny((CharSequence)url, (char[])new char[]{'?', '#'});
        if (urlRemainderPos >= 0) {
            urlRemainder = url.substring(urlRemainderPos);
            url = url.substring(0, urlRemainderPos);
        }
        url = URLDecoder.decode(url, StandardCharsets.UTF_8);
        Object rewrittenUrl = this.urlHandler.get(url).buildExternalResourceUrl();
        if (urlRemainder != null) {
            rewrittenUrl = rewrittenUrl == null ? urlRemainder : (String)rewrittenUrl + urlRemainder;
        }
        if (StringUtils.equals((CharSequence)url, (CharSequence)rewrittenUrl)) {
            log.debug("Rewrite element {}: Skip - URL is already externalized: {}", (Object)name, (Object)url);
            this.contentHandler.startElement(nsUri, name, raw, attrs);
            return;
        }
        log.debug("Rewrite element {}: Rewrite URL {} to {}", new Object[]{name, url, rewrittenUrl});
        AttributesImpl newAttrs = new AttributesImpl(attrs);
        newAttrs.setValue(attributeIndex, (String)rewrittenUrl);
        this.contentHandler.startElement(nsUri, name, raw, newAttrs);
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    public void dispose() {
    }
}

