/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.rewriter.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UrlExternalizerTransformerConfig {
    static final String PN_REWRITE_ELEMENTS = "rewriteElements";
    private static final String[] REWRITE_ELEMENTS_DEFAULT = new String[]{"img:src", "link:href", "script:src"};
    private static final String ELEMENT_ATTRIBUTE_SEPARATOR = ":";
    private final Map<String, String> elementAttributeNames;
    private static final Logger log = LoggerFactory.getLogger((String)UrlExternalizerTransformerConfig.class.getName());

    UrlExternalizerTransformerConfig(ValueMap config) {
        this.elementAttributeNames = UrlExternalizerTransformerConfig.toElementAttributeNamesMap((String[])config.get(PN_REWRITE_ELEMENTS, (Object)REWRITE_ELEMENTS_DEFAULT));
    }

    private static Map<String, String> toElementAttributeNamesMap(String[] elementAttributeNames) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : elementAttributeNames) {
            String elementName = StringUtils.trim((String)StringUtils.substringBefore((String)item, (String)ELEMENT_ATTRIBUTE_SEPARATOR));
            String attributeName = StringUtils.trim((String)StringUtils.substringAfter((String)item, (String)ELEMENT_ATTRIBUTE_SEPARATOR));
            if (StringUtils.isBlank((CharSequence)elementName) || StringUtils.isBlank((CharSequence)attributeName)) {
                log.info("Invalid URL externalizier transformer configuration - skipping invalid element entry: {}", (Object)item);
                continue;
            }
            if (map.containsKey(elementName)) {
                log.info("Invalid URL externalizier transformer configuration - skipping duplicate element name: {}", (Object)item);
                continue;
            }
            map.put(elementName, attributeName);
        }
        return map;
    }

    public Map<String, String> getElementAttributeNames() {
        return this.elementAttributeNames;
    }
}

