/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.suffix.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.sling.api.resource.Resource;

public final class UrlSuffixUtil {
    public static final char SUFFIX_PART_DELIMITER = '/';
    public static final char KEY_VALUE_DELIMITER = '=';
    public static final String ESCAPE_DELIMITER = "~";
    public static final String ESCAPED_SLASH = "~" + UrlSuffixUtil.hexCode('/');
    private static final String[][] SPECIAL_CHARS_MAPPING = new String[][]{{Character.toString('/'), "~" + UrlSuffixUtil.hexCode('/')}, {Character.toString('='), "~" + UrlSuffixUtil.hexCode('=')}, {Character.toString('.'), "~" + UrlSuffixUtil.hexCode('.')}, {Character.toString('%'), "~" + UrlSuffixUtil.hexCode('%')}, {Character.toString('/'), "~" + UrlSuffixUtil.hexCode('/')}, {Character.toString(':'), "~" + UrlSuffixUtil.hexCode(':')}, {Character.toString(' '), "~" + UrlSuffixUtil.hexCode(' ')}};
    private static final CharSequenceTranslator ESCAPE_SPECIAL_CHARS = new LookupTranslator((CharSequence[][])SPECIAL_CHARS_MAPPING);
    private static final CharSequenceTranslator UNESCAPE_SPECIAL_CHARS = new LookupTranslator((CharSequence[][])EntityArrays.invert((String[][])SPECIAL_CHARS_MAPPING));

    private UrlSuffixUtil() {
    }

    public static String hexCode(char c) {
        return Integer.toString(c, 16).toUpperCase();
    }

    public static String encodeResourcePathPart(String relativePath) {
        return ESCAPE_SPECIAL_CHARS.translate((CharSequence)relativePath);
    }

    public static String decodeResourcePathPart(String suffixPart) {
        return UNESCAPE_SPECIAL_CHARS.translate((CharSequence)suffixPart);
    }

    public static String encodeKeyValuePart(String string) {
        return ESCAPE_SPECIAL_CHARS.translate((CharSequence)string);
    }

    public static String decodeValue(String suffixPart) {
        String value = StringUtils.substringAfter((String)suffixPart, (String)Character.toString('='));
        return UNESCAPE_SPECIAL_CHARS.translate((CharSequence)value);
    }

    public static String decodeKey(String suffixPart) {
        String key = StringUtils.substringBefore((String)suffixPart, (String)Character.toString('='));
        return UNESCAPE_SPECIAL_CHARS.translate((CharSequence)key);
    }

    public static String[] splitSuffix(String suffix) {
        String[] parts;
        String theSuffix = suffix;
        if (StringUtils.isBlank((CharSequence)theSuffix)) {
            parts = new String[]{};
        } else {
            if (theSuffix.startsWith(ESCAPED_SLASH)) {
                theSuffix = theSuffix.substring(ESCAPED_SLASH.length());
            }
            theSuffix = StringUtils.substringBeforeLast((String)theSuffix, (String)".");
            parts = StringUtils.split((String)theSuffix, (char)'/');
        }
        return parts;
    }

    public static Map<String, Object> keyValuePairAsMap(String key, Object value) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(key, value);
        return paramMap;
    }

    public static String getRelativePath(Resource resource, Resource baseResource) {
        String basePath;
        if (baseResource == null) {
            throw new IllegalArgumentException("the base resource for constructing relative path must not be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("the resource for constructing relative path must not be null");
        }
        String absolutePath = resource.getPath();
        if (absolutePath.equals(basePath = baseResource.getPath())) {
            return ".";
        }
        if (!absolutePath.startsWith(basePath + "/")) {
            throw new IllegalArgumentException("the resource " + String.valueOf(resource) + " is not a descendent of the base resource " + String.valueOf(baseResource));
        }
        return StringUtils.substringAfter((String)absolutePath, (String)(basePath + "/"));
    }
}

