/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.url.ui;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import io.wcm.handler.url.spi.UrlHandlerConfig;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.util.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class SiteRoot {
    private Page siteRootPage;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;
    @AemObject
    private PageManager pageManager;
    @Self
    private UrlHandlerConfig urlHandlerConfig;

    @Nullable
    public String getRootPath(@Nullable Page page) {
        if (page == null) {
            return null;
        }
        return this.getRootPath((Resource)page.adaptTo(Resource.class));
    }

    @Nullable
    public String getRootPath(@Nullable Resource resource) {
        int rootLevel = this.urlHandlerConfig.getSiteRootLevel(resource);
        if (rootLevel > 0 && resource != null) {
            return Path.getAbsoluteParent((String)resource.getPath(), (int)rootLevel, (ResourceResolver)resource.getResourceResolver());
        }
        return null;
    }

    @Nullable
    public String getRootPath() {
        return this.getRootPath(this.currentPage);
    }

    @Nullable
    public Page getRootPage() {
        String rootPath;
        if (this.siteRootPage == null && (rootPath = this.getRootPath()) != null) {
            this.siteRootPage = this.pageManager.getPage(this.getRootPath());
        }
        return this.siteRootPage;
    }

    @Nullable
    public Page getRelativePage(@NotNull String relativePath) {
        String path = this.getRootPath();
        if (path == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(path);
        if (!relativePath.startsWith("/")) {
            sb.append("/");
        }
        sb.append(relativePath);
        return this.pageManager.getPage(sb.toString());
    }

    public boolean isRootPage(@NotNull Page page) {
        return StringUtils.equals((CharSequence)page.getPath(), (CharSequence)this.getRootPath());
    }
}

