/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.resource;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public final class ImmutableValueMap
implements ValueMap {
    private final ValueMap map;

    private ImmutableValueMap(ValueMap map) {
        this.map = map;
    }

    private ImmutableValueMap(Map<String, Object> map) {
        this.map = new ValueMapDecorator(map);
    }

    public <T> T get(String name, Class<T> type) {
        return (T)this.map.get(name, type);
    }

    public <T> T get(String name, T defaultValue) {
        return (T)this.map.get(name, defaultValue);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    @Deprecated
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static ImmutableValueMap of() {
        return new ImmutableValueMap(ValueMap.EMPTY);
    }

    public static ImmutableValueMap of(String k1, Object v1) {
        return new ImmutableValueMap((Map<String, Object>)ImmutableMap.of((Object)k1, (Object)v1));
    }

    public static ImmutableValueMap of(String k1, Object v1, String k2, Object v2) {
        return new ImmutableValueMap((Map<String, Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2));
    }

    public static ImmutableValueMap of(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return new ImmutableValueMap((Map<String, Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3));
    }

    public static ImmutableValueMap of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return new ImmutableValueMap((Map<String, Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4, (Object)v4));
    }

    public static ImmutableValueMap of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        return new ImmutableValueMap((Map<String, Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4, (Object)v4, (Object)k5, (Object)v5));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ImmutableValueMap copyOf(Map<String, Object> map) {
        if (map instanceof ValueMap) {
            return new ImmutableValueMap((ValueMap)map);
        }
        return new ImmutableValueMap(map);
    }

    public static final class Builder {
        private Map<String, Object> map = new HashMap<String, Object>();

        public Builder put(String key, Object value) {
            this.map.put(key, value);
            return this;
        }

        public Builder put(Map.Entry<String, Object> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        public Builder putAll(Map<String, Object> value) {
            this.map.putAll(value);
            return this;
        }

        public ImmutableValueMap build() {
            if (this.map.isEmpty()) {
                return ImmutableValueMap.of();
            }
            return new ImmutableValueMap(this.map);
        }
    }
}

