/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Escape {
    private Escape() {
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String validName(String value) {
        String text = value.toLowerCase();
        text = StringUtils.replace((String)text, (String)"\u00e4", (String)"ae");
        text = StringUtils.replace((String)text, (String)"\u00f6", (String)"oe");
        text = StringUtils.replace((String)text, (String)"\u00fc", (String)"ue");
        text = StringUtils.replace((String)text, (String)"\u00df", (String)"ss");
        StringBuilder sb = new StringBuilder(text);
        for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_') continue;
            ch = '-';
            sb.setCharAt(i, ch);
        }
        return sb.toString();
    }

    public static String validFilename(String value) {
        String fileExtension = StringUtils.substringAfterLast((String)value, (String)".");
        String fileName = StringUtils.substringBeforeLast((String)value, (String)".");
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return Escape.validName(fileName);
        }
        return Escape.validName(fileName) + "." + Escape.validName(fileExtension);
    }
}

