/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import io.wcm.sling.commons.caservice.impl.ContextAwareServiceTracker;
import io.wcm.sling.commons.caservice.impl.ResolveAllResultImpl;
import io.wcm.sling.commons.caservice.impl.ServiceInfo;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ContextAwareServiceResolver.class}, immediate=true)
public class ContextAwareServiceResolverImpl
implements ContextAwareServiceResolver {
    private BundleContext bundleContext;
    private final LoadingCache<String, ContextAwareServiceTracker> serviceTrackerCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, ContextAwareServiceTracker>(){

        public void onRemoval(RemovalNotification<String, ContextAwareServiceTracker> notification) {
            ((ContextAwareServiceTracker)notification.getValue()).dispose();
        }
    }).build((CacheLoader)new CacheLoader<String, ContextAwareServiceTracker>(){

        public ContextAwareServiceTracker load(String className) {
            return new ContextAwareServiceTracker(className, ContextAwareServiceResolverImpl.this.bundleContext);
        }
    });

    @Activate
    private void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Deactivate
    private void deactivate(BundleContext context) {
        this.serviceTrackerCache.invalidateAll();
    }

    @Override
    public <T extends ContextAwareService> T resolve(Class<T> serviceClass, Adaptable adaptable) {
        Resource resource = this.getResource(adaptable);
        ContextAwareServiceTracker serviceTracker = this.getServiceTracker(serviceClass);
        return (T)((ContextAwareService)serviceTracker.resolve(resource).map(serviceInfo -> serviceInfo.getService()).findFirst().orElse(null));
    }

    @Override
    public <T extends ContextAwareService> ContextAwareServiceResolver.ResolveAllResult<T> resolveAll(Class<T> serviceClass, Adaptable adaptable) {
        Resource resource = this.getResource(adaptable);
        ContextAwareServiceTracker serviceTracker = this.getServiceTracker(serviceClass);
        return new ResolveAllResultImpl<ContextAwareService>(serviceTracker.resolve(resource).map(serviceInfo -> serviceInfo.getService()), () -> this.buildCombinedKey(serviceTracker, serviceTracker.resolve(resource)));
    }

    private String buildCombinedKey(ContextAwareServiceTracker serviceTracker, Stream<ServiceInfo> result) {
        return serviceTracker.getLastServiceChangeTimestamp() + "\n" + result.map(ServiceInfo::getKey).collect(Collectors.joining("\n~\n"));
    }

    private Resource getResource(Adaptable adaptable) {
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)adaptable).getResource();
        }
        return null;
    }

    private ContextAwareServiceTracker getServiceTracker(Class<?> serviceClass) {
        try {
            return (ContextAwareServiceTracker)this.serviceTrackerCache.get((Object)serviceClass.getName());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error getting service tracker for " + serviceClass.getName() + " from cache.", ex);
        }
    }

    ConcurrentMap<String, ContextAwareServiceTracker> getContextAwareServiceTrackerMap() {
        return this.serviceTrackerCache.asMap();
    }
}

