/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.resource;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public final class ResourceType {
    public static final String APPS_PREFIX = "/apps/";
    public static final String LIBS_PREFIX = "/libs/";

    private ResourceType() {
    }

    public static String makeAbsolute(String resourceType, ResourceResolver resourceResolver) {
        if (StringUtils.isEmpty((CharSequence)resourceType) || StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/")) {
            return resourceType;
        }
        ComponentManager componentManager = (ComponentManager)resourceResolver.adaptTo(ComponentManager.class);
        if (componentManager != null) {
            Component component = componentManager.getComponent(resourceType);
            if (component != null) {
                return component.getPath();
            }
            return resourceType;
        }
        Resource resource = resourceResolver.getResource(resourceType);
        if (resource != null) {
            return resource.getPath();
        }
        return resourceType;
    }

    public static String makeRelative(String resourceType) {
        if (StringUtils.startsWith((CharSequence)resourceType, (CharSequence)APPS_PREFIX)) {
            return resourceType.substring(APPS_PREFIX.length());
        }
        if (StringUtils.startsWith((CharSequence)resourceType, (CharSequence)LIBS_PREFIX)) {
            return resourceType.substring(LIBS_PREFIX.length());
        }
        return resourceType;
    }

    public static boolean equals(String resourceType, String anotherResourceType) {
        return StringUtils.equals((CharSequence)ResourceType.makeRelative(resourceType), (CharSequence)ResourceType.makeRelative(anotherResourceType));
    }

    public static boolean is(Resource resource, String resourceType) {
        if (resource == null || resourceType == null) {
            return false;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        boolean result = false;
        if (ResourceType.equals(resourceType, resource.getResourceType())) {
            result = true;
        } else {
            HashSet<String> superTypesChecked = new HashSet<String>();
            String superType = resolver.getParentResourceType(resource);
            while (!result && superType != null) {
                if (ResourceType.equals(resourceType, superType)) {
                    result = true;
                    continue;
                }
                superTypesChecked.add(superType);
                if ((superType = resolver.getParentResourceType(superType)) == null || !superTypesChecked.contains(superType)) continue;
                throw new SlingException("Cyclic dependency for resourceSuperType hierarchy detected on resource " + resource.getPath(), null);
            }
        }
        return result;
    }
}

