/*
 * Decompiled with CFR 0.152.
 */
package wcmiohandlercommons.org.apache.sling.commons.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class BundleFileProcessor {
    private final File input;
    private final File outputFolder;

    public BundleFileProcessor(File input, File outputFolder) {
        this.input = input;
        this.outputFolder = outputFolder;
    }

    protected abstract Manifest processManifest(Manifest var1);

    protected abstract String getTargetFilename(Manifest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File process() throws IOException {
        ZipInputStream jis = null;
        try {
            jis = new JarInputStream(new FileInputStream(this.input));
            Manifest oldMF = ((JarInputStream)jis).getManifest();
            Manifest newMF = this.processManifest(oldMF);
            File newBundle = new File(this.outputFolder, this.getTargetFilename(oldMF));
            ZipOutputStream jos = null;
            try {
                jos = new JarOutputStream((OutputStream)new FileOutputStream(newBundle), newMF);
                JarEntry je = null;
                while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                    try {
                        ((JarOutputStream)jos).putNextEntry(je);
                        if (je.isDirectory()) continue;
                        BundleFileProcessor.pumpStream(jis, jos);
                    }
                    finally {
                        jos.closeEntry();
                        jis.closeEntry();
                    }
                }
            }
            finally {
                if (jos != null) {
                    jos.close();
                }
            }
            File file = newBundle;
            return file;
        }
        finally {
            if (jis != null) {
                jis.close();
            }
        }
    }

    static void pumpStream(InputStream is, OutputStream os) throws IOException {
        byte[] bytes = new byte[65536];
        int length = 0;
        int offset = 0;
        while ((length = is.read(bytes, offset, bytes.length - offset)) != -1) {
            if ((offset += length) != bytes.length) continue;
            os.write(bytes, 0, bytes.length);
            offset = 0;
        }
        if (offset != 0) {
            os.write(bytes, 0, offset);
        }
    }
}

