/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.request;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class RequestParam {
    public static final String PARAMETER_FORMENCODING = "_charset_";

    private RequestParam() {
    }

    public static String get(ServletRequest request, String param) {
        return RequestParam.get(request, param, null);
    }

    public static String get(ServletRequest request, String param, String defaultValue) {
        String value = request.getParameter(param);
        if (value != null) {
            if (!RequestParam.hasFormEncodingParam(request)) {
                value = RequestParam.convertISO88591toUTF8(value);
            }
            return value;
        }
        return defaultValue;
    }

    public static String[] getMultiple(ServletRequest request, String param) {
        String[] values = request.getParameterValues(param);
        if (values == null) {
            return null;
        }
        if (!RequestParam.hasFormEncodingParam(request)) {
            String[] convertedValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                convertedValues[i] = RequestParam.convertISO88591toUTF8(values[i]);
            }
            return convertedValues;
        }
        return values;
    }

    public static String get(Map<String, String[]> requestMap, String param) {
        String value = null;
        String[] valueArray = requestMap.get(param);
        if (valueArray != null && valueArray.length > 0) {
            value = valueArray[0];
        }
        if (value != null && !RequestParam.hasFormEncodingParam(requestMap)) {
            value = RequestParam.convertISO88591toUTF8(value);
        }
        return value;
    }

    public static int getInt(ServletRequest request, String param) {
        return RequestParam.getInt(request, param, 0);
    }

    public static int getInt(ServletRequest request, String param, int defaultValue) {
        String value = request.getParameter(param);
        return NumberUtils.toInt((String)value, (int)defaultValue);
    }

    public static long getLong(ServletRequest request, String param) {
        return RequestParam.getLong(request, param, 0L);
    }

    public static long getLong(ServletRequest request, String param, long defaultValue) {
        String value = request.getParameter(param);
        return NumberUtils.toLong((String)value, (long)defaultValue);
    }

    public static float getFloat(ServletRequest request, String param) {
        return RequestParam.getFloat(request, param, 0.0f);
    }

    public static float getFloat(ServletRequest request, String param, float defaultValue) {
        String value = request.getParameter(param);
        return NumberUtils.toFloat((String)value, (float)defaultValue);
    }

    public static double getDouble(ServletRequest request, String param) {
        return RequestParam.getDouble(request, param, 0.0);
    }

    public static double getDouble(ServletRequest request, String param, double defaultValue) {
        String value = request.getParameter(param);
        return NumberUtils.toDouble((String)value, (double)defaultValue);
    }

    public static boolean getBoolean(ServletRequest request, String param) {
        return RequestParam.getBoolean(request, param, false);
    }

    public static boolean getBoolean(ServletRequest request, String param, boolean defaultValue) {
        String value = request.getParameter(param);
        return BooleanUtils.toBoolean((String)value);
    }

    public static <T extends Enum> T getEnum(ServletRequest request, String param, Class<T> enumClass) {
        return RequestParam.getEnum(request, param, enumClass, null);
    }

    public static <T extends Enum> T getEnum(ServletRequest request, String param, Class<T> enumClass, T defaultValue) {
        String value = RequestParam.get(request, param);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                return Enum.valueOf(enumClass, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static boolean hasFormEncodingParam(ServletRequest request) {
        return StringUtils.isNotEmpty((CharSequence)request.getParameter(PARAMETER_FORMENCODING));
    }

    private static boolean hasFormEncodingParam(Map<String, String[]> requestMap) {
        String[] valueArray = requestMap.get(PARAMETER_FORMENCODING);
        return valueArray != null && valueArray.length > 0;
    }

    private static String convertISO88591toUTF8(String value) {
        try {
            return new String(value.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }
}

