/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.impl.ContextAwareServiceTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceInfo {
    private final ContextAwareService service;
    private final Map<String, Object> serviceProperties;
    private final Pattern contextPathRegex;
    private final Pattern contextPathBlacklistRegex;
    private final boolean acceptsContextPathEmpty;
    private final String key;
    private boolean valid = true;
    private static final Logger log = LoggerFactory.getLogger(ContextAwareServiceTracker.class);
    private static final ToStringStyle TO_STRING_STYLE = new ToStringStyle(){
        private static final long serialVersionUID = 1L;
        {
            this.setUseIdentityHashCode(false);
            this.setContentStart(" [");
        }
    };

    ServiceInfo(ServiceReference<?> serviceReference, BundleContext bundleContext) {
        this.service = this.validateAndGetService(serviceReference, bundleContext);
        this.serviceProperties = this.propertiesToMap(serviceReference);
        this.contextPathRegex = this.validateAndParsePattern(serviceReference, "Wcmio-CAService-ContextPathRegex");
        this.contextPathBlacklistRegex = this.validateAndParsePattern(serviceReference, "Wcmio-CAService-ContextPathBlacklistRegex");
        this.acceptsContextPathEmpty = this.validateAndGetBoolan(this.lookupServicePropertyBundleHeader(serviceReference, "Wcmio-CASService-AcceptsContextPathEmpty"));
        this.key = this.buildKey();
    }

    private ContextAwareService validateAndGetService(ServiceReference<?> serviceReference, BundleContext bundleContext) {
        Object serviceObject = bundleContext.getService(serviceReference);
        if (serviceObject instanceof ContextAwareService) {
            return (ContextAwareService)serviceObject;
        }
        log.warn("Service implementation " + serviceObject.getClass().getName() + " does not implement the ContextAwareService interface - service will be ignored for context-aware service resolution.");
        this.valid = false;
        return null;
    }

    private Map<String, Object> propertiesToMap(ServiceReference<?> reference) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propertyName : reference.getPropertyKeys()) {
            props.put(propertyName, reference.getProperty(propertyName));
        }
        return props;
    }

    private Object lookupServicePropertyBundleHeader(ServiceReference<?> serviceReference, String propertyName) {
        Object value = serviceReference.getProperty(propertyName);
        if (value == null) {
            value = serviceReference.getBundle().getHeaders().get(propertyName);
        }
        return value;
    }

    private Pattern validateAndParsePattern(ServiceReference<?> serviceReference, String patternPropertyName) {
        Object value = this.lookupServicePropertyBundleHeader(serviceReference, patternPropertyName);
        if (value == null || value instanceof String) {
            String patternString = (String)value;
            if (StringUtils.isEmpty((CharSequence)patternString)) {
                return null;
            }
            try {
                return Pattern.compile(patternString);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        log.warn("Invalid " + patternPropertyName + " regex pattern '" + value + "' - service " + this.service.getClass().getName() + " from bundle " + serviceReference.getBundle().getSymbolicName() + " will be ignored for context-aware service resolution.");
        this.valid = false;
        return null;
    }

    private boolean validateAndGetBoolan(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return BooleanUtils.toBoolean((String)((String)value));
        }
        return false;
    }

    public ContextAwareService getService() {
        return this.service;
    }

    public Map<String, Object> getServiceProperties() {
        return this.serviceProperties;
    }

    public boolean matches(String resourcePath) {
        if (!this.valid) {
            return false;
        }
        if (resourcePath == null) {
            return this.acceptsContextPathEmpty;
        }
        if (this.contextPathRegex != null && !this.contextPathRegex.matcher(resourcePath).matches()) {
            return false;
        }
        return this.contextPathBlacklistRegex == null || !this.contextPathBlacklistRegex.matcher(resourcePath).matches();
    }

    private String buildKey() {
        return "[wl]" + this.contextPathRegex + "\n[bl]" + this.contextPathBlacklistRegex + "\n";
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this.service, TO_STRING_STYLE);
        if (this.contextPathRegex != null) {
            builder.append("contextPathRegex", (Object)this.contextPathRegex);
        }
        if (this.contextPathBlacklistRegex != null) {
            builder.append("contextPathBlacklistRegex", (Object)this.contextPathBlacklistRegex);
        }
        if (this.acceptsContextPathEmpty) {
            builder.append("acceptsContextPathEmpty", this.acceptsContextPathEmpty);
        }
        return builder.build();
    }
}

