/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.request;

import io.wcm.sling.commons.util.Escape;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class QueryStringBuilder {
    private static final String PARAM_SEPARATOR = "&";
    private static final String VALUE_SEPARATOR = "=";
    private List<NameValuePair> params = new ArrayList<NameValuePair>();

    public QueryStringBuilder param(String name, Object value) {
        if (value instanceof Iterable) {
            Iterable valueItems = (Iterable)value;
            for (Object valueItem : valueItems) {
                this.params.add(new NameValuePair(name, valueItem));
            }
        } else if (QueryStringBuilder.isArray(value)) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object valueItem = Array.get(value, i);
                this.params.add(new NameValuePair(name, valueItem));
            }
        } else {
            this.params.add(new NameValuePair(name, value));
        }
        return this;
    }

    public QueryStringBuilder params(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.param(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String build() {
        StringBuilder queryString = new StringBuilder();
        for (NameValuePair param : this.params) {
            if (queryString.length() > 0) {
                queryString.append(PARAM_SEPARATOR);
            }
            queryString.append(Escape.urlEncode(param.getName()));
            queryString.append(VALUE_SEPARATOR);
            queryString.append(Escape.urlEncode(param.getValue()));
        }
        if (queryString.length() > 0) {
            return queryString.toString();
        }
        return null;
    }

    private static boolean isArray(Object value) {
        return value != null && value.getClass().isArray();
    }

    private static class NameValuePair {
        private final String name;
        private final String value;

        NameValuePair(String name, Object value) {
            this.name = name;
            this.value = value != null ? value.toString() : "";
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

