/*
 * Decompiled with CFR 0.152.
 */
package wcmiohandlercommons.org.apache.sling.commons.osgi.bundleversion;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import wcmiohandlercommons.org.apache.sling.commons.osgi.bundleversion.BundleVersionInfo;

public class FileBundleVersionInfo
extends BundleVersionInfo<File> {
    private final String symbolicName;
    private final Version version;
    private final boolean isSnapshot;
    private final long lastModified;
    private final File source;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBundleVersionInfo(File bundle) throws IOException {
        block7: {
            this.source = bundle;
            JarFile f = new JarFile(bundle);
            try {
                Manifest m = f.getManifest();
                if (m == null) {
                    this.symbolicName = null;
                    this.version = null;
                    this.isSnapshot = false;
                    this.lastModified = -1L;
                    break block7;
                }
                this.symbolicName = m.getMainAttributes().getValue("Bundle-SymbolicName");
                String v = m.getMainAttributes().getValue("Bundle-Version");
                this.version = v == null ? null : new Version(v);
                this.isSnapshot = v != null && v.contains("SNAPSHOT");
                String last = m.getMainAttributes().getValue("Bnd-LastModified");
                long lastMod = -1L;
                if (last != null) {
                    try {
                        lastMod = Long.parseLong(last);
                    }
                    catch (NumberFormatException ignore) {
                        // empty catch block
                    }
                }
                this.lastModified = lastMod;
            }
            finally {
                f.close();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.source.getAbsolutePath();
    }

    @Override
    public boolean isBundle() {
        return this.symbolicName != null;
    }

    @Override
    public long getBundleLastModified() {
        return this.lastModified;
    }

    @Override
    public String getBundleSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isSnapshot() {
        return this.isSnapshot;
    }
}

