/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.PathPreprocessor;
import io.wcm.sling.commons.caservice.impl.ServiceInfo;
import java.util.stream.Stream;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wcmiohandlercommons.org.apache.sling.commons.osgi.Order;
import wcmiohandlercommons.org.apache.sling.commons.osgi.RankedServices;

class ContextAwareServiceTracker
implements ServiceTrackerCustomizer<ContextAwareService, ServiceInfo> {
    private final BundleContext bundleContext;
    private final PathPreprocessor pathPreprocessor;
    private final ServiceTracker<ContextAwareService, ServiceInfo> serviceTracker;
    private volatile RankedServices<ServiceInfo> rankedServices;
    private volatile long lastServiceChange;
    private static final Logger log = LoggerFactory.getLogger(ContextAwareServiceTracker.class);

    ContextAwareServiceTracker(String serviceClassName, BundleContext bundleContext, PathPreprocessor pathPreprocessor) {
        this.bundleContext = bundleContext;
        this.pathPreprocessor = pathPreprocessor;
        this.rankedServices = new RankedServices(Order.DESCENDING);
        this.serviceTracker = new ServiceTracker(bundleContext, serviceClassName, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void dispose() {
        this.serviceTracker.close();
        this.rankedServices = null;
    }

    public ServiceInfo addingService(ServiceReference<ContextAwareService> reference) {
        ServiceInfo serviceInfo = new ServiceInfo(reference, this.bundleContext);
        if (log.isDebugEnabled()) {
            log.debug("Add service {}", (Object)serviceInfo.getService().getClass().getName());
        }
        if (this.rankedServices != null) {
            this.rankedServices.bind(serviceInfo, serviceInfo.getServiceProperties());
        }
        this.lastServiceChange = System.currentTimeMillis();
        return serviceInfo;
    }

    public void modifiedService(ServiceReference<ContextAwareService> reference, ServiceInfo serviceInfo) {
    }

    public void removedService(ServiceReference<ContextAwareService> reference, ServiceInfo serviceInfo) {
        if (log.isDebugEnabled()) {
            log.debug("Remove service {}", (Object)serviceInfo.getService().getClass().getName());
        }
        if (this.rankedServices != null) {
            this.rankedServices.unbind(serviceInfo, serviceInfo.getServiceProperties());
        }
        this.lastServiceChange = System.currentTimeMillis();
        this.bundleContext.ungetService(reference);
    }

    public Stream<ServiceInfo> resolve(Resource resource) {
        if (this.rankedServices == null) {
            return Stream.empty();
        }
        return this.rankedServices.getList().stream().filter(serviceInfo -> this.matchesResource((ServiceInfo)serviceInfo, resource));
    }

    private boolean matchesResource(ServiceInfo serviceInfo, Resource resource) {
        String path = null;
        if (resource != null) {
            path = resource.getPath();
            if (this.pathPreprocessor != null) {
                path = this.pathPreprocessor.apply(path, resource.getResourceResolver());
            }
        }
        return serviceInfo.matches(path);
    }

    public long getLastServiceChangeTimestamp() {
        return this.lastServiceChange;
    }

    public Iterable<ServiceInfo> getServiceInfos() {
        return this.rankedServices;
    }
}

