/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.request.impl;

import io.wcm.sling.commons.request.RequestContext;
import java.io.IOException;
import java.util.Stack;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(service={RequestContext.class, Filter.class}, immediate=true, property={"sling.filter.scope=component"})
public final class RequestContextFilterImpl
implements RequestContext,
Filter {
    private static final ThreadLocal<Stack<SlingHttpServletRequest>> REQUEST_THREADLOCAL = new ThreadLocal<Stack<SlingHttpServletRequest>>(){

        @Override
        protected Stack<SlingHttpServletRequest> initialValue() {
            return new Stack<SlingHttpServletRequest>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest) {
            REQUEST_THREADLOCAL.get().push((SlingHttpServletRequest)request);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            REQUEST_THREADLOCAL.get().pop();
        }
    }

    @Override
    public SlingHttpServletRequest getThreadRequest() {
        Stack<SlingHttpServletRequest> stack = REQUEST_THREADLOCAL.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

