/*
 * #%L
 * wcm.io
 * %%
 * Copyright (C) 2018 wcm.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package io.wcm.sling.commons.caservice;

import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * Allows to preprocess a path before matching it against the regular experessions
 * of the context-aware services.
 */
@ConsumerType
public interface PathPreprocessor {

  /**
   * Preprocess a path.
   * @param path Path (never null)
   * @param resourceResolver Resource resolver
   * @return Processed path or same path
   */
  @NotNull
  String apply(@NotNull String path, @NotNull ResourceResolver resourceResolver);

}
