/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.ContextAwareServiceCollectionResolver;
import io.wcm.sling.commons.caservice.impl.CollectionItemDecoration;
import io.wcm.sling.commons.caservice.impl.ResourcePathResolver;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.sling.api.adapter.Adaptable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextAwareServiceCollectionResolverImpl<S extends ContextAwareService, D>
implements ContextAwareServiceCollectionResolver<S, D> {
    private final Collection<ServiceReference<S>> serviceReferenceCollection;
    private final ResourcePathResolver resourcePathResolver;
    private final LoadingCache<ServiceReference<S>, CollectionItemDecoration<S, D>> decorationCache;
    private static final Logger log = LoggerFactory.getLogger(ContextAwareServiceCollectionResolverImpl.class);

    ContextAwareServiceCollectionResolverImpl(@NotNull Collection<ServiceReference<S>> serviceReferenceCollection, @NotNull @NotNull BiFunction<@NotNull ServiceReference<S>, @Nullable S, @Nullable D> decorator, @NotNull ResourcePathResolver resourcePathResolver, @NotNull BundleContext bundleContext) {
        this.serviceReferenceCollection = serviceReferenceCollection;
        this.resourcePathResolver = resourcePathResolver;
        this.decorationCache = ContextAwareServiceCollectionResolverImpl.buildCache(decorator, bundleContext);
    }

    private static <S extends ContextAwareService, D> LoadingCache<ServiceReference<S>, CollectionItemDecoration<S, D>> buildCache(final @NotNull @NotNull BiFunction<@NotNull ServiceReference<S>, @Nullable S, @Nullable D> decorator, final @NotNull BundleContext bundleContext) {
        return CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).removalListener(notification -> {
            log.debug("Remove service {}", notification.getValue());
            bundleContext.ungetService((ServiceReference)notification.getKey());
        }).build(new CacheLoader<ServiceReference<S>, CollectionItemDecoration<S, D>>(){

            public CollectionItemDecoration<S, D> load(ServiceReference<S> serviceReference) {
                CollectionItemDecoration item = new CollectionItemDecoration(serviceReference, decorator, bundleContext);
                log.debug("Add service {}", item);
                return item;
            }
        });
    }

    @Override
    @Nullable
    public S resolve(@Nullable Adaptable adaptable) {
        return (S)((ContextAwareService)this.getMatching(adaptable).map(CollectionItemDecoration::getService).findFirst().orElse(null));
    }

    @Override
    @NotNull
    public Stream<S> resolveAll(@Nullable Adaptable adaptable) {
        return this.getMatching(adaptable).map(CollectionItemDecoration::getService);
    }

    @Override
    @Nullable
    public D resolveDecorated(@Nullable Adaptable adaptable) {
        return this.getMatching(adaptable).map(CollectionItemDecoration::getDecoration).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public Stream<D> resolveAllDecorated(@Nullable Adaptable adaptable) {
        return this.getMatching(adaptable).map(CollectionItemDecoration::getDecoration);
    }

    @NotNull
    private Stream<CollectionItemDecoration<S, D>> getMatching(@Nullable Adaptable adaptable) {
        String resourcePath = this.resourcePathResolver.get(adaptable);
        return this.serviceReferenceCollection.stream().map(arg_0 -> this.decorationCache.getUnchecked(arg_0)).filter(CollectionItemDecoration::isValid).filter(item -> item.matches(resourcePath));
    }

    @Override
    public void close() {
        this.decorationCache.invalidateAll();
    }
}

