/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.ContextAwareServiceCollectionResolver;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import io.wcm.sling.commons.caservice.PathPreprocessor;
import io.wcm.sling.commons.caservice.impl.ContextAwareServiceCollectionResolverImpl;
import io.wcm.sling.commons.caservice.impl.ContextAwareServiceTracker;
import io.wcm.sling.commons.caservice.impl.ResolveAllResultImpl;
import io.wcm.sling.commons.caservice.impl.ResourcePathResolver;
import io.wcm.sling.commons.caservice.impl.ServiceInfo;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.adapter.Adaptable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContextAwareServiceResolver.class}, immediate=true)
public class ContextAwareServiceResolverImpl
implements ContextAwareServiceResolver {
    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private PathPreprocessor pathPreprocessor;
    private BundleContext bundleContext;
    private ResourcePathResolver resourcePathResolver;
    private LoadingCache<String, ContextAwareServiceTracker<ContextAwareService>> serviceTrackerCache;
    private static final Logger log = LoggerFactory.getLogger(ContextAwareServiceResolverImpl.class);

    @Activate
    private void activate(BundleContext context) {
        this.bundleContext = context;
        this.resourcePathResolver = new ResourcePathResolver(this.pathPreprocessor);
        this.serviceTrackerCache = ContextAwareServiceResolverImpl.buildServiceTrackerCache(context);
    }

    @Deactivate
    private void deactivate() {
        this.serviceTrackerCache.invalidateAll();
    }

    private static <S extends ContextAwareService> LoadingCache<String, ContextAwareServiceTracker<S>> buildServiceTrackerCache(final BundleContext bundleContext) {
        return CacheBuilder.newBuilder().removalListener(new RemovalListener<String, ContextAwareServiceTracker<S>>(){

            public void onRemoval(RemovalNotification<String, ContextAwareServiceTracker<S>> notification) {
                ((ContextAwareServiceTracker)notification.getValue()).dispose();
            }
        }).build(new CacheLoader<String, ContextAwareServiceTracker<S>>(){

            public ContextAwareServiceTracker load(String className) {
                return new ContextAwareServiceTracker(className, bundleContext);
            }
        });
    }

    @Override
    public <S extends ContextAwareService> S resolve(@NotNull Class<S> serviceClass, @Nullable Adaptable adaptable) {
        ContextAwareServiceTracker<S> serviceTracker = this.getServiceTracker(serviceClass);
        return (S)((ContextAwareService)ContextAwareServiceResolverImpl.getValidServices(this.getMatchingServiceInfos(serviceTracker, adaptable)).findFirst().orElse(null));
    }

    @Override
    @NotNull
    public <S extends ContextAwareService> ContextAwareServiceResolver.ResolveAllResult<S> resolveAll(@NotNull Class<S> serviceClass, @Nullable Adaptable adaptable) {
        ContextAwareServiceTracker<S> serviceTracker = this.getServiceTracker(serviceClass);
        Stream<S> services = ContextAwareServiceResolverImpl.getValidServices(this.getMatchingServiceInfos(serviceTracker, adaptable));
        Supplier<String> combinedKey = ContextAwareServiceResolverImpl.buildCombinedKey(serviceTracker.getLastServiceChangeTimestamp(), this.getMatchingServiceInfos(serviceTracker, adaptable));
        return new ResolveAllResultImpl<S>(services, combinedKey);
    }

    @Override
    @NotNull
    public <S extends ContextAwareService> ContextAwareServiceCollectionResolver<S, Void> getCollectionResolver(@NotNull Collection<ServiceReference<S>> serviceReferenceCollection) {
        return this.getCollectionResolver(serviceReferenceCollection, (ref, service) -> null);
    }

    @Override
    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    @NotNull
    public <S extends ContextAwareService, D> ContextAwareServiceCollectionResolver<S, D> getCollectionResolver(@NotNull Collection<ServiceReference<S>> serviceReferenceCollection, @NotNull @NotNull BiFunction<@NotNull ServiceReference<S>, @Nullable S, @Nullable D> decorator) {
        return new ContextAwareServiceCollectionResolverImpl<S, D>(serviceReferenceCollection, decorator, this.resourcePathResolver, this.bundleContext);
    }

    private <S extends ContextAwareService> Stream<ServiceInfo<S>> getMatchingServiceInfos(@NotNull ContextAwareServiceTracker<S> serviceTracker, @Nullable Adaptable adaptable) {
        String resourcePath = this.resourcePathResolver.get(adaptable);
        if (log.isTraceEnabled()) {
            log.trace("Resolve {} for resource {}", (Object)serviceTracker.getServiceClassName(), (Object)resourcePath);
        }
        return serviceTracker.resolve(resourcePath);
    }

    private <S extends ContextAwareService> ContextAwareServiceTracker<S> getServiceTracker(Class<S> serviceClass) {
        try {
            return (ContextAwareServiceTracker)this.serviceTrackerCache.get((Object)serviceClass.getName());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error getting service tracker for " + serviceClass.getName() + " from cache.", ex);
        }
    }

    ConcurrentMap<String, ContextAwareServiceTracker<ContextAwareService>> getContextAwareServiceTrackerMap() {
        return this.serviceTrackerCache.asMap();
    }

    private static <S extends ContextAwareService> Stream<S> getValidServices(Stream<ServiceInfo<S>> serviceInfos) {
        return serviceInfos.filter(ServiceInfo::isValid).map(ServiceInfo::getService);
    }

    @NotNull
    private static <S extends ContextAwareService> Supplier<String> buildCombinedKey(long timestamp, @NotNull Stream<ServiceInfo<S>> serviceInfos) {
        return () -> timestamp + "\n" + serviceInfos.map(ServiceInfo::getKey).collect(Collectors.joining("\n~\n"));
    }
}

