/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.impl.ServiceInfo;
import java.util.function.BiFunction;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class CollectionItemDecoration<S extends ContextAwareService, D> {
    @Nullable
    private final S service;
    @Nullable
    private final D decoration;
    private final ServiceInfo<S> serviceInfo;

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    CollectionItemDecoration(@NotNull ServiceReference<S> serviceReference, @NotNull @NotNull BiFunction<@NotNull ServiceReference<S>, @Nullable S, @Nullable D> decorator, @NotNull BundleContext bundleContext) {
        this.service = (ContextAwareService)bundleContext.getService(serviceReference);
        this.decoration = decorator.apply(serviceReference, this.service);
        this.serviceInfo = new ServiceInfo<S>(serviceReference, this.service);
    }

    boolean isValid() {
        return this.serviceInfo.isValid();
    }

    boolean matches(@Nullable String resourcePath) {
        return this.serviceInfo.matches(resourcePath);
    }

    @Nullable
    S getService() {
        return this.service;
    }

    @Nullable
    D getDecoration() {
        return this.decoration;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("service", this.service).append("serviceInfo", this.serviceInfo).append("decoration", this.decoration).toString();
    }
}

