/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.ContextAwareServiceCollectionResolver;
import io.wcm.sling.commons.caservice.impl.CollectionItemDecoration;
import io.wcm.sling.commons.caservice.impl.ResourcePathResolver;
import io.wcm.sling.commons.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import io.wcm.sling.commons.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.sling.api.adapter.Adaptable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextAwareServiceCollectionResolverImpl<S extends ContextAwareService, D>
implements ContextAwareServiceCollectionResolver<S, D> {
    private final Collection<ServiceReference<S>> serviceReferenceCollection;
    private final ResourcePathResolver resourcePathResolver;
    private final LoadingCache<ServiceReference<S>, CollectionItemDecoration<S, D>> decorationCache;
    private static final Logger log = LoggerFactory.getLogger(ContextAwareServiceCollectionResolverImpl.class);

    ContextAwareServiceCollectionResolverImpl(@NotNull Collection<ServiceReference<S>> serviceReferenceCollection, @NotNull @NotNull BiFunction<@NotNull ServiceReference<S>, @Nullable S, @Nullable D> decorator, @NotNull ResourcePathResolver resourcePathResolver, @NotNull BundleContext bundleContext) {
        this.serviceReferenceCollection = serviceReferenceCollection;
        this.resourcePathResolver = resourcePathResolver;
        this.decorationCache = ContextAwareServiceCollectionResolverImpl.buildCache(decorator, bundleContext);
    }

    private static <S extends ContextAwareService, D> LoadingCache<ServiceReference<S>, CollectionItemDecoration<S, D>> buildCache(@NotNull @NotNull BiFunction<@NotNull ServiceReference<S>, @Nullable S, @Nullable D> decorator, @NotNull BundleContext bundleContext) {
        return Caffeine.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).removalListener((key, value, cause) -> {
            log.debug("Remove service {}", value);
            bundleContext.ungetService(key);
        }).build(serviceReference -> {
            CollectionItemDecoration item = new CollectionItemDecoration(serviceReference, decorator, bundleContext);
            log.debug("Add service {}", item);
            return item;
        });
    }

    @Override
    @Nullable
    public S resolve(@Nullable Adaptable adaptable) {
        return (S)((ContextAwareService)this.getMatching(adaptable).map(CollectionItemDecoration::getService).findFirst().orElse(null));
    }

    @Override
    @NotNull
    public Stream<S> resolveAll(@Nullable Adaptable adaptable) {
        return this.getMatching(adaptable).map(CollectionItemDecoration::getService);
    }

    @Override
    @Nullable
    public D resolveDecorated(@Nullable Adaptable adaptable) {
        return this.getMatching(adaptable).map(CollectionItemDecoration::getDecoration).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public Stream<D> resolveAllDecorated(@Nullable Adaptable adaptable) {
        return this.getMatching(adaptable).map(CollectionItemDecoration::getDecoration);
    }

    @NotNull
    private Stream<CollectionItemDecoration<S, D>> getMatching(@Nullable Adaptable adaptable) {
        String resourcePath = this.resourcePathResolver.get(adaptable);
        return this.serviceReferenceCollection.stream().map(this.decorationCache::get).filter(CollectionItemDecoration::isValid).filter(item -> item.matches(resourcePath));
    }

    @Override
    public void close() {
        this.decorationCache.invalidateAll();
    }
}

