/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import io.wcm.sling.commons.caservice.impl.ContextAwareServiceResolverImpl;
import io.wcm.sling.commons.caservice.impl.ContextAwareServiceTracker;
import io.wcm.sling.commons.caservice.impl.ServiceInfo;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InventoryPrinter.class}, property={"felix.inventory.printer.name=wcmio-caservice", "felix.inventory.printer.title=wcm.io Context-Aware Services", "felix.inventory.printer.format=TEXT"})
public class ContextAwareServiceInventoryPrinter
implements InventoryPrinter {
    @Reference
    private ContextAwareServiceResolver contextAwareServiceResolver;

    public void print(PrintWriter pw, Format format, boolean isZip) {
        if (format != Format.TEXT) {
            return;
        }
        if (!(this.contextAwareServiceResolver instanceof ContextAwareServiceResolverImpl)) {
            return;
        }
        ConcurrentMap<String, ContextAwareServiceTracker<ContextAwareService>> map = ((ContextAwareServiceResolverImpl)this.contextAwareServiceResolver).getContextAwareServiceTrackerMap();
        if (map.isEmpty()) {
            pw.println();
            pw.println("No context-aware services found.");
            pw.println("The services are registered lazily on first access of the service interface or class.");
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            pw.println();
            pw.println((String)entry.getKey());
            pw.println(StringUtils.repeat((char)'-', (int)((String)entry.getKey()).length()));
            for (ServiceInfo serviceInfo : ((ContextAwareServiceTracker)entry.getValue()).getServiceInfos()) {
                pw.print("- ");
                pw.println(serviceInfo.toString());
            }
        }
    }
}

