/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import io.wcm.sling.commons.caservice.ContextAwareService;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceInfo<S extends ContextAwareService> {
    private static final Pattern PATTERN_MATCH_ALL = Pattern.compile(".*");
    @Nullable
    private final S service;
    private final Map<String, Object> servicePropertiesMap;
    private final Pattern contextPathRegex;
    private final Pattern contextPathBlacklistRegex;
    private final boolean acceptsContextPathEmpty;
    private final String key;
    private final boolean valid;
    private static final Logger log = LoggerFactory.getLogger(ServiceInfo.class);
    private static final ToStringStyle TO_STRING_STYLE = new ToStringStyle(){
        private static final long serialVersionUID = 1L;
        {
            this.setUseIdentityHashCode(false);
            this.setContentStart(" [");
        }
    };

    ServiceInfo(@NotNull ServiceReference<S> serviceReference, @NotNull BundleContext bundleContext) {
        this(serviceReference, ServiceInfo.validateAndGetService(serviceReference, bundleContext));
    }

    ServiceInfo(@NotNull ServiceReference<S> serviceReference, @Nullable S service) {
        this.service = service;
        this.servicePropertiesMap = ServiceInfo.propertiesToMap(serviceReference);
        this.contextPathRegex = ServiceInfo.validateAndParsePattern(serviceReference, service, "Wcmio-CAService-ContextPathRegex");
        this.contextPathBlacklistRegex = ServiceInfo.validateAndParsePattern(serviceReference, service, "Wcmio-CAService-ContextPathBlacklistRegex");
        this.acceptsContextPathEmpty = ServiceInfo.validateAndGetBoolan(ServiceInfo.lookupServicePropertyBundleHeader(serviceReference, "Wcmio-CASService-AcceptsContextPathEmpty"));
        this.key = this.buildKey();
        this.valid = service != null && this.contextPathRegex != null && this.contextPathBlacklistRegex != null;
    }

    @Nullable
    private static <S extends ContextAwareService> S validateAndGetService(@NotNull ServiceReference<S> serviceReference, @NotNull BundleContext bundleContext) {
        Object serviceObject = bundleContext.getService(serviceReference);
        if (serviceObject instanceof ContextAwareService) {
            return (S)((ContextAwareService)serviceObject);
        }
        if (log.isWarnEnabled()) {
            log.warn("Service implementation {} does not implement the ContextAwareService interface - service will be ignored for context-aware service resolution.", (Object)(serviceObject != null ? serviceObject.getClass().getName() : ""));
        }
        return null;
    }

    private static <S extends ContextAwareService> Map<String, Object> propertiesToMap(@NotNull ServiceReference<S> reference) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propertyName : reference.getPropertyKeys()) {
            props.put(propertyName, reference.getProperty(propertyName));
        }
        return props;
    }

    private static <S extends ContextAwareService> Object lookupServicePropertyBundleHeader(@NotNull ServiceReference<S> serviceReference, @NotNull String propertyName) {
        Object value = serviceReference.getProperty(propertyName);
        if (value == null) {
            value = serviceReference.getBundle().getHeaders().get(propertyName);
        }
        return value;
    }

    private static <S extends ContextAwareService> Pattern validateAndParsePattern(@NotNull ServiceReference<S> serviceReference, @Nullable S service, @NotNull String patternPropertyName) {
        Object value = ServiceInfo.lookupServicePropertyBundleHeader(serviceReference, patternPropertyName);
        if (value == null || value instanceof String) {
            String patternString = (String)value;
            if (StringUtils.isEmpty((CharSequence)patternString)) {
                return PATTERN_MATCH_ALL;
            }
            try {
                return Pattern.compile(patternString);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("Invalid {} regex pattern '{}' - service {} from bundle {} will be ignored for context-aware service resolution.", new Object[]{patternPropertyName, value, service != null ? service.getClass().getName() : "", serviceReference.getBundle().getSymbolicName()});
        }
        return null;
    }

    private static boolean validateAndGetBoolan(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return BooleanUtils.toBoolean((String)((String)value));
        }
        return false;
    }

    @Nullable
    public S getService() {
        return this.service;
    }

    public Map<String, Object> getServiceProperties() {
        return this.servicePropertiesMap;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean matches(String resourcePath) {
        if (!this.valid) {
            return false;
        }
        if (resourcePath == null) {
            return this.acceptsContextPathEmpty;
        }
        if (this.contextPathRegex != PATTERN_MATCH_ALL && !this.contextPathRegex.matcher(resourcePath).matches()) {
            return false;
        }
        return this.contextPathBlacklistRegex == PATTERN_MATCH_ALL || !this.contextPathBlacklistRegex.matcher(resourcePath).matches();
    }

    private String buildKey() {
        return "[wl]" + this.contextPathRegex + "\n[bl]" + this.contextPathBlacklistRegex + "\n";
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.service, TO_STRING_STYLE);
        if (this.contextPathRegex != null) {
            builder.append("contextPathRegex", (Object)this.contextPathRegex);
        }
        if (this.contextPathBlacklistRegex != null) {
            builder.append("contextPathBlacklistRegex", (Object)this.contextPathBlacklistRegex);
        }
        if (this.acceptsContextPathEmpty) {
            builder.append("acceptsContextPathEmpty", this.acceptsContextPathEmpty);
        }
        return builder.build();
    }
}

